/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.protobuf.DescriptorProtos;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.druid.data.input.protobuf.DescriptorBasedProtobufBytesDecoder;
import org.apache.druid.java.util.common.parsers.ParseException;

public class FileBasedProtobufBytesDecoder
extends DescriptorBasedProtobufBytesDecoder {
    private final String descriptorFilePath;

    @JsonCreator
    public FileBasedProtobufBytesDecoder(@JsonProperty(value="descriptor") String descriptorFilePath, @JsonProperty(value="protoMessageType") String protoMessageType) {
        super(protoMessageType);
        Preconditions.checkNotNull((Object)descriptorFilePath);
        this.descriptorFilePath = descriptorFilePath;
        this.initializeDescriptor();
    }

    @JsonProperty(value="descriptor")
    public String getDescriptorFilePath() {
        return this.descriptorFilePath;
    }

    @Override
    protected DescriptorProtos.FileDescriptorSet loadFileDescriptorSet() {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet;
        block10: {
            InputStream fin = this.getClass().getClassLoader().getResourceAsStream(this.descriptorFilePath);
            try {
                if (fin == null) {
                    throw new ParseException(this.descriptorFilePath, "Descriptor not found in class path [%s]", new Object[]{this.descriptorFilePath});
                }
                DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(fin);
                if (descriptorSet.getFileCount() == 0) {
                    throw new ParseException(null, "No file descriptors found in the descriptor set", new Object[0]);
                }
                fileDescriptorSet = descriptorSet;
                if (fin == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ParseException(this.descriptorFilePath, (Throwable)e, "Failed to initialize descriptor", new Object[0]);
                }
            }
            fin.close();
        }
        return fileDescriptorSet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileBasedProtobufBytesDecoder that = (FileBasedProtobufBytesDecoder)o;
        return Objects.equals(this.descriptorFilePath, that.descriptorFilePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.descriptorFilePath);
    }
}

