/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kafkainput;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.kafkainput.KafkaHeaderFormat;
import org.apache.druid.data.input.kafkainput.KafkaHeaderReader;
import org.apache.druid.data.input.kafkainput.KafkaStringHeaderReader;
import org.apache.kafka.common.header.Headers;

public class KafkaStringHeaderFormat
implements KafkaHeaderFormat {
    private final Charset encoding;

    public KafkaStringHeaderFormat(@JsonProperty(value="encoding") @Nullable String encoding) {
        this.encoding = encoding != null ? Charset.forName(encoding) : StandardCharsets.UTF_8;
    }

    @Nullable
    @JsonProperty
    public String getEncoding() {
        return this.encoding.name();
    }

    @Override
    public KafkaHeaderReader createReader(Headers headers, String headerLabelPrefix) {
        return new KafkaStringHeaderReader(headers, headerLabelPrefix, this.encoding);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaStringHeaderFormat that = (KafkaStringHeaderFormat)o;
        return Objects.equals(this.encoding, that.encoding);
    }

    public int hashCode() {
        return Objects.hash(this.encoding);
    }
}

