/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization;

import io.github.bucket4j.BucketExceptions;
import java.time.Duration;

public class DelayParameters {
    public final long maxUnsynchronizedTokens;
    public final long maxUnsynchronizedTimeoutNanos;

    public DelayParameters(long maxUnsynchronizedTokens, Duration maxTimeoutBetweenSynchronization) {
        this.maxUnsynchronizedTokens = maxUnsynchronizedTokens;
        if (maxUnsynchronizedTokens <= 0L) {
            throw BucketExceptions.nonPositiveTokensForDelayParameters(maxUnsynchronizedTokens);
        }
        if (maxTimeoutBetweenSynchronization == null) {
            throw BucketExceptions.nullMaxTimeoutBetweenSynchronizationForDelayParameters();
        }
        if (maxTimeoutBetweenSynchronization.isNegative() || maxTimeoutBetweenSynchronization.isZero()) {
            throw BucketExceptions.nonPositiveMaxTimeoutBetweenSynchronizationForDelayParameters(maxTimeoutBetweenSynchronization);
        }
        this.maxUnsynchronizedTimeoutNanos = maxTimeoutBetweenSynchronization.toNanos();
    }
}

