/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.MathType;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.HashMap;
import java.util.Map;

public class ThreadUnsafeBucket
extends AbstractBucket
implements LocalBucket,
ComparableByContent<ThreadUnsafeBucket> {
    private BucketConfiguration configuration;
    private final TimeMeter timeMeter;
    private BucketState state;
    public static final SerializationHandle<ThreadUnsafeBucket> SERIALIZATION_HANDLE = new SerializationHandle<ThreadUnsafeBucket>(){

        @Override
        public <S> ThreadUnsafeBucket deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            BucketConfiguration bucketConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
            BucketState bucketState = BucketState.deserialize(adapter, input, backwardCompatibilityVersion);
            bucketState.setConfiguration(bucketConfiguration);
            return new ThreadUnsafeBucket(BucketListener.NOPE, TimeMeter.SYSTEM_MILLISECONDS, bucketState);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, ThreadUnsafeBucket bucket, Version backwardCompatibilityVersion) throws IOException {
            if (bucket.timeMeter != TimeMeter.SYSTEM_MILLISECONDS) {
                throw new NotSerializableException("Only TimeMeter.SYSTEM_MILLISECONDS can be serialized safely");
            }
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            BucketConfiguration.SERIALIZATION_HANDLE.serialize(adapter, output, bucket.state.getConfiguration(), backwardCompatibilityVersion);
            BucketState.serialize(adapter, output, bucket.state, backwardCompatibilityVersion);
        }

        @Override
        public int getTypeId() {
            return 62;
        }

        @Override
        public Class<ThreadUnsafeBucket> getSerializedType() {
            return ThreadUnsafeBucket.class;
        }

        @Override
        public ThreadUnsafeBucket fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            Map stateSnapshot = (Map)snapshot.get("state");
            BucketState state = BucketState.fromJsonCompatibleSnapshot(stateSnapshot, backwardCompatibilityVersion);
            return new ThreadUnsafeBucket(BucketListener.NOPE, TimeMeter.SYSTEM_MILLISECONDS, state);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(ThreadUnsafeBucket bucket, Version backwardCompatibilityVersion) throws IOException {
            if (bucket.timeMeter != TimeMeter.SYSTEM_MILLISECONDS) {
                throw new NotSerializableException("Only TimeMeter.SYSTEM_MILLISECONDS can be serialized safely");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("state", BucketState.toJsonCompatibleSnapshot(bucket.state, backwardCompatibilityVersion));
            return result;
        }

        @Override
        public String getTypeName() {
            return "ThreadUnsafeBucket";
        }
    };

    public ThreadUnsafeBucket(BucketConfiguration configuration, MathType mathType, TimeMeter timeMeter) {
        this(BucketListener.NOPE, timeMeter, BucketState.createInitialState(configuration, mathType, timeMeter.currentTimeNanos()));
    }

    private ThreadUnsafeBucket(BucketListener listener, TimeMeter timeMeter, BucketState initialState) {
        super(listener);
        this.configuration = initialState.getConfiguration();
        this.timeMeter = timeMeter;
        this.state = initialState;
    }

    public void setConfiguration(BucketConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Bucket toListenable(BucketListener listener) {
        return new ThreadUnsafeBucket(listener, this.timeMeter, this.state);
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        long toConsume = Math.min(limit, availableToConsume);
        if (toConsume == 0L) {
            return 0L;
        }
        this.state.consume(toConsume);
        return toConsume;
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        if (tokensToConsume > availableToConsume) {
            return false;
        }
        this.state.consume(tokensToConsume);
        return true;
    }

    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        if (tokensToConsume > availableToConsume) {
            long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, true);
            long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
            return ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
        }
        this.state.consume(tokensToConsume);
        long remainingTokens = availableToConsume - tokensToConsume;
        long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
        return ConsumptionProbe.consumed(remainingTokens, nanosToWaitForReset);
    }

    @Override
    protected EstimationProbe estimateAbilityToConsumeImpl(long tokensToEstimate) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        if (tokensToEstimate > availableToConsume) {
            long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos, true);
            return EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
        }
        return EstimationProbe.canBeConsumed(availableToConsume);
    }

    @Override
    protected long reserveAndCalculateTimeToSleepImpl(long tokensToConsume, long waitIfBusyNanosLimit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
        if (nanosToCloseDeficit == Long.MAX_VALUE || nanosToCloseDeficit > waitIfBusyNanosLimit) {
            return Long.MAX_VALUE;
        }
        this.state.consume(tokensToConsume);
        return nanosToCloseDeficit;
    }

    @Override
    protected long consumeIgnoringRateLimitsImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
        if (nanosToCloseDeficit == INFINITY_DURATION) {
            return nanosToCloseDeficit;
        }
        this.state.consume(tokensToConsume);
        return nanosToCloseDeficit;
    }

    @Override
    protected VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        long toConsume = Math.min(limit, availableToConsume);
        if (toConsume == 0L) {
            return new VerboseResult<Long>(currentTimeNanos, 0L, this.state.copy());
        }
        this.state.consume(toConsume);
        return new VerboseResult<Long>(currentTimeNanos, toConsume, this.state.copy());
    }

    @Override
    protected VerboseResult<Boolean> tryConsumeVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        if (tokensToConsume > availableToConsume) {
            return new VerboseResult<Boolean>(currentTimeNanos, false, this.state.copy());
        }
        this.state.consume(tokensToConsume);
        return new VerboseResult<Boolean>(currentTimeNanos, true, this.state.copy());
    }

    @Override
    protected VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        if (tokensToConsume > availableToConsume) {
            long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, true);
            long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
            ConsumptionProbe probe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
            return new VerboseResult<ConsumptionProbe>(currentTimeNanos, probe, this.state.copy());
        }
        this.state.consume(tokensToConsume);
        long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
        ConsumptionProbe probe = ConsumptionProbe.consumed(availableToConsume - tokensToConsume, nanosToWaitForReset);
        return new VerboseResult<ConsumptionProbe>(currentTimeNanos, probe, this.state.copy());
    }

    @Override
    protected VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long tokensToEstimate) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens();
        if (tokensToEstimate > availableToConsume) {
            long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos, true);
            EstimationProbe estimationProbe = EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
            return new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, this.state.copy());
        }
        EstimationProbe estimationProbe = EstimationProbe.canBeConsumed(availableToConsume);
        return new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, this.state.copy());
    }

    @Override
    protected VerboseResult<Long> getAvailableTokensVerboseImpl() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long availableTokens = this.state.getAvailableTokens();
        return new VerboseResult<Long>(currentTimeNanos, availableTokens, this.state.copy());
    }

    @Override
    protected VerboseResult<Nothing> addTokensVerboseImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state.addTokens(tokensToAdd);
        return new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.state.copy());
    }

    @Override
    protected VerboseResult<Nothing> forceAddTokensVerboseImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state.forceAddTokens(tokensToAdd);
        return new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.state.copy());
    }

    @Override
    protected VerboseResult<Nothing> resetVerboseImpl() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state.reset();
        return new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.state.copy());
    }

    @Override
    protected VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state = this.state.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
        this.configuration = newConfiguration;
        return new VerboseResult<Object>(currentTimeNanos, null, this.state.copy());
    }

    @Override
    protected VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
        if (nanosToCloseDeficit == INFINITY_DURATION) {
            return new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, this.state.copy());
        }
        this.state.consume(tokensToConsume);
        return new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, this.state.copy());
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state.addTokens(tokensToAdd);
    }

    @Override
    protected void forceAddTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state.forceAddTokens(tokensToAdd);
    }

    @Override
    public void reset() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state.reset();
    }

    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        return this.state.getAvailableTokens();
    }

    @Override
    protected void replaceConfigurationImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(currentTimeNanos);
        this.state = this.state.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
        this.configuration = newConfiguration;
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public TimeMeter getTimeMeter() {
        return this.timeMeter;
    }

    @Override
    public SynchronizationStrategy getSynchronizationStrategy() {
        return SynchronizationStrategy.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ThreadUnsafeBucket threadUnsafeBucket = this;
        synchronized (threadUnsafeBucket) {
            return "ThreadUnsafeBucket{state=" + this.state + ", configuration=" + this.getConfiguration() + '}';
        }
    }

    @Override
    public boolean equalsByContent(ThreadUnsafeBucket other) {
        return ComparableByContent.equals(this.state, other.state) && ComparableByContent.equals(this.state.getConfiguration(), other.getConfiguration()) && this.timeMeter == other.timeMeter;
    }
}

