/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.List;
import java.util.Objects;

public class MongoDatabaseInfo
implements DatabaseInfo {
    private final ServiceType type;
    private final ServiceType executeQueryType;
    private final String databaseId;
    private final String realUrl;
    private final String normalizedUrl;
    private final List<String> host;
    private final String multipleHost;
    private final boolean parsingComplete;
    private final String collectionName;
    private final String readPreference;
    private final String writeConcern;

    public MongoDatabaseInfo(ServiceType type, ServiceType executeQueryType, String realUrl, String normalizedUrl, List<String> host, String databaseId, String collectionName, String readWriteOption, String writeConcern) {
        this(type, executeQueryType, realUrl, normalizedUrl, host, databaseId, collectionName, true, readWriteOption, writeConcern);
    }

    public MongoDatabaseInfo(ServiceType type, ServiceType executeQueryType, String realUrl, String normalizedUrl, List<String> host, String databaseId, String collectionName, boolean parsingComplete, String readPreference, String writeConcern) {
        this.type = Objects.requireNonNull(type, "type");
        this.executeQueryType = Objects.requireNonNull(executeQueryType, "executeQueryType");
        this.realUrl = realUrl;
        this.normalizedUrl = normalizedUrl;
        this.host = host;
        this.multipleHost = this.merge(host);
        this.databaseId = databaseId;
        this.parsingComplete = parsingComplete;
        this.readPreference = readPreference;
        this.writeConcern = writeConcern;
        this.collectionName = collectionName;
    }

    private String merge(List<String> host) {
        if (host.isEmpty()) {
            return "";
        }
        String single = host.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(single);
        for (int i = 1; i < host.size(); ++i) {
            sb.append(',');
            sb.append(host.get(i));
        }
        return sb.toString();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getReadPreference() {
        return this.readPreference;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public List<String> getHost() {
        return this.host;
    }

    @Override
    public String getMultipleHost() {
        return this.multipleHost;
    }

    @Override
    public String getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public String getRealUrl() {
        return this.realUrl;
    }

    @Override
    public String getUrl() {
        return this.normalizedUrl;
    }

    @Override
    public ServiceType getType() {
        return this.type;
    }

    @Override
    public ServiceType getExecuteQueryType() {
        return this.executeQueryType;
    }

    @Override
    public boolean isParsingComplete() {
        return this.parsingComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MongoDatabaseInfo{");
        sb.append("type=").append(this.type);
        sb.append(", executeQueryType=").append(this.executeQueryType);
        sb.append(", databaseId='").append(this.databaseId).append('\'');
        sb.append(", realUrl='").append(this.realUrl).append('\'');
        sb.append(", normalizedUrl='").append(this.normalizedUrl).append('\'');
        sb.append(", host=").append(this.host);
        sb.append(", multipleHost='").append(this.multipleHost).append('\'');
        sb.append(", parsingComplete=").append(this.parsingComplete);
        sb.append(", readPreference=").append(this.readPreference);
        sb.append(", writeConcern=").append(this.writeConcern);
        sb.append(", collectionName=").append(this.collectionName);
        sb.append('}');
        return sb.toString();
    }
}

