/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.producer;

import io.cloudevents.CloudEvent;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.producer.GrpcProducer;
import org.apache.eventmesh.client.grpc.util.EventMeshCloudEventBuilder;
import org.apache.eventmesh.common.enums.EventMeshProtocolType;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventProducer
implements GrpcProducer<CloudEvent> {
    private static final Logger log = LoggerFactory.getLogger(CloudEventProducer.class);
    private static final EventMeshProtocolType PROTOCOL_TYPE = EventMeshProtocolType.CLOUD_EVENTS;
    private final transient EventMeshGrpcClientConfig clientConfig;
    private final transient PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient;

    public CloudEventProducer(EventMeshGrpcClientConfig clientConfig, PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient) {
        this.clientConfig = clientConfig;
        this.publisherClient = publisherClient;
    }

    @Override
    public Response publish(List<CloudEvent> events) {
        if (log.isInfoEnabled()) {
            log.info("BatchPublish message, batch size={}", (Object)events.size());
        }
        if (CollectionUtils.isEmpty(events)) {
            return null;
        }
        CloudEventBatch cloudEventBatch = EventMeshCloudEventBuilder.buildEventMeshCloudEventBatch(events, this.clientConfig, PROTOCOL_TYPE);
        try {
            org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent response = this.publisherClient.batchPublish(cloudEventBatch);
            Response parsedResponse = Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent)response)).respMsg(EventMeshCloudEventUtils.getResponseMessage((org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent)response)).respTime(EventMeshCloudEventUtils.getResponseTime((org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent)response)).build();
            if (log.isInfoEnabled()) {
                log.info("Received response:{}", (Object)parsedResponse);
            }
            return parsedResponse;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error in BatchPublish message {}", events, (Object)e);
            }
            return null;
        }
    }

    @Override
    public Response publish(CloudEvent cloudEvent) {
        if (log.isInfoEnabled()) {
            log.info("Publish message: {}", (Object)cloudEvent.toString());
        }
        org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent enhancedMessage = EventMeshCloudEventBuilder.buildEventMeshCloudEvent(cloudEvent, this.clientConfig, PROTOCOL_TYPE);
        try {
            org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent response = this.publisherClient.publish(enhancedMessage);
            Response parsedResponse = Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent)response)).respMsg(EventMeshCloudEventUtils.getResponseMessage((org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent)response)).respTime(EventMeshCloudEventUtils.getResponseTime((org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent)response)).build();
            if (log.isInfoEnabled()) {
                log.info("Received response:{} ", (Object)parsedResponse);
            }
            return parsedResponse;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error in publishing message {}", (Object)cloudEvent, (Object)e);
            }
            return null;
        }
    }

    @Override
    public CloudEvent requestReply(CloudEvent cloudEvent, long timeout) {
        if (log.isInfoEnabled()) {
            log.info("RequestReply message {}", (Object)cloudEvent);
        }
        org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent enhancedMessage = EventMeshCloudEventBuilder.buildEventMeshCloudEvent(cloudEvent, this.clientConfig, PROTOCOL_TYPE);
        try {
            org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent reply = this.publisherClient.requestReply(enhancedMessage);
            if (log.isInfoEnabled()) {
                log.info("Received reply message:{}", (Object)reply);
            }
            return (CloudEvent)EventMeshCloudEventBuilder.buildMessageFromEventMeshCloudEvent(reply, PROTOCOL_TYPE);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error in RequestReply message {}", (Object)cloudEvent, (Object)e);
            }
            return null;
        }
    }
}

