/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import io.cloudevents.CloudEvent;
import io.openmessaging.api.Message;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.producer.CloudEventProducer;
import org.apache.eventmesh.client.http.producer.EventMeshMessageProducer;
import org.apache.eventmesh.client.http.producer.OpenMessageProducer;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshHttpProducer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(EventMeshHttpProducer.class);
    private final EventMeshMessageProducer eventMeshMessageProducer;
    private final CloudEventProducer cloudEventProducer;
    private final OpenMessageProducer openMessageProducer;

    public EventMeshHttpProducer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        this.cloudEventProducer = new CloudEventProducer(eventMeshHttpClientConfig);
        this.eventMeshMessageProducer = new EventMeshMessageProducer(eventMeshHttpClientConfig);
        this.openMessageProducer = new OpenMessageProducer(eventMeshHttpClientConfig);
    }

    public void publish(EventMeshMessage message) throws EventMeshException {
        this.eventMeshMessageProducer.publish(message);
    }

    public void publish(CloudEvent cloudEvent) throws EventMeshException {
        this.cloudEventProducer.publish(cloudEvent);
    }

    public void publish(Message openMessage) throws EventMeshException {
        this.openMessageProducer.publish(openMessage);
    }

    public EventMeshMessage request(EventMeshMessage message, long timeout) throws EventMeshException {
        return this.eventMeshMessageProducer.request(message, timeout);
    }

    public CloudEvent request(CloudEvent cloudEvent, long timeout) throws EventMeshException {
        return this.cloudEventProducer.request(cloudEvent, timeout);
    }

    public Message request(Message openMessage, long timeout) throws EventMeshException {
        return this.openMessageProducer.request(openMessage, timeout);
    }

    public void request(EventMeshMessage message, RRCallback<EventMeshMessage> rrCallback, long timeout) throws EventMeshException {
        this.eventMeshMessageProducer.request(message, rrCallback, timeout);
    }

    public void request(CloudEvent cloudEvent, RRCallback<CloudEvent> rrCallback, long timeout) throws EventMeshException {
        this.cloudEventProducer.request(cloudEvent, rrCallback, timeout);
    }

    public void request(Message openMessage, RRCallback<Message> rrCallback, long timeout) throws EventMeshException {
        this.openMessageProducer.request(openMessage, rrCallback, timeout);
    }

    @Override
    public void close() throws EventMeshException {
        try (EventMeshMessageProducer ignored = this.eventMeshMessageProducer;
             OpenMessageProducer ignored1 = this.openMessageProducer;
             CloudEventProducer ignored2 = this.cloudEventProducer;){
            log.info("Close producer");
        }
    }
}

