/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.event.ConsumerGroupStateEvent;
import org.apache.eventmesh.runtime.core.consumergroup.event.ConsumerGroupTopicConfChangeEvent;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerGroupManager;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager {
    private static final Logger log = LoggerFactory.getLogger(ConsumerManager.class);
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private ConcurrentHashMap<String, ConsumerGroupManager> consumerTable = new ConcurrentHashMap(64);

    public ConsumerManager(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void init() throws Exception {
        this.eventMeshHTTPServer.getEventBus().register((Object)this);
        log.info("consumerManager inited......");
    }

    public void start() throws Exception {
        log.info("consumerManager started......");
    }

    public void notifyConsumerManager(String consumerGroup, ConsumerGroupConf latestConsumerGroupConfig) throws Exception {
        ConsumerGroupManager cgm = this.eventMeshHTTPServer.getConsumerManager().getConsumer(consumerGroup);
        if (latestConsumerGroupConfig == null) {
            ConsumerGroupStateEvent notification = new ConsumerGroupStateEvent();
            notification.setAction(ConsumerGroupStateEvent.ConsumerGroupStateAction.DELETE);
            notification.setConsumerGroup(consumerGroup);
            this.eventMeshHTTPServer.getEventBus().post((Object)notification);
            return;
        }
        if (cgm == null) {
            ConsumerGroupStateEvent notification = new ConsumerGroupStateEvent();
            notification.setAction(ConsumerGroupStateEvent.ConsumerGroupStateAction.NEW);
            notification.setConsumerGroup(consumerGroup);
            notification.setConsumerGroupConfig(EventMeshUtil.cloneObject(latestConsumerGroupConfig));
            this.eventMeshHTTPServer.getEventBus().post((Object)notification);
            return;
        }
        if (!latestConsumerGroupConfig.equals(cgm.getConsumerGroupConfig())) {
            ConsumerGroupStateEvent notification = new ConsumerGroupStateEvent();
            notification.setAction(ConsumerGroupStateEvent.ConsumerGroupStateAction.CHANGE);
            notification.setConsumerGroup(consumerGroup);
            notification.setConsumerGroupConfig(EventMeshUtil.cloneObject(latestConsumerGroupConfig));
            this.eventMeshHTTPServer.getEventBus().post((Object)notification);
            return;
        }
    }

    public void shutdown() {
        this.eventMeshHTTPServer.getEventBus().unregister((Object)this);
        for (ConsumerGroupManager consumerGroupManager : this.consumerTable.values()) {
            try {
                consumerGroupManager.shutdown();
            }
            catch (Exception ex) {
                log.error("shutdown consumerGroupManager[{}] err", (Object)consumerGroupManager, (Object)ex);
            }
        }
        log.info("consumerManager shutdown......");
    }

    public boolean contains(String consumerGroup) {
        return this.consumerTable.containsKey(consumerGroup);
    }

    public synchronized void addConsumer(String consumerGroup, ConsumerGroupConf consumerGroupConfig) throws Exception {
        ConsumerGroupManager cgm = new ConsumerGroupManager(this.eventMeshHTTPServer, consumerGroupConfig);
        cgm.init();
        cgm.start();
        this.consumerTable.put(consumerGroup, cgm);
    }

    public synchronized void restartConsumer(String consumerGroup, ConsumerGroupConf consumerGroupConfig) throws Exception {
        if (this.consumerTable.containsKey(consumerGroup)) {
            ConsumerGroupManager cgm = this.consumerTable.get(consumerGroup);
            cgm.refresh(consumerGroupConfig);
        }
    }

    public ConsumerGroupManager getConsumer(String consumerGroup) {
        return this.consumerTable.get(consumerGroup);
    }

    public synchronized void delConsumer(String consumerGroup) throws Exception {
        log.info("start delConsumer with consumerGroup {}", (Object)consumerGroup);
        if (this.consumerTable.containsKey(consumerGroup)) {
            ConsumerGroupManager cgm = this.consumerTable.remove(consumerGroup);
            log.info("start unsubscribe topic with consumer group manager {}", (Object)JsonUtils.toJSONString((Object)cgm));
            cgm.unsubscribe(consumerGroup);
            cgm.shutdown();
        }
        log.info("end delConsumer with consumerGroup {}", (Object)consumerGroup);
    }

    @Subscribe
    public void handleConsumerGroupTopicConfChangeEvent(ConsumerGroupTopicConfChangeEvent event) {
        try {
            log.info("onChange event:{}", (Object)event);
            switch (event.getAction()) {
                case NEW: {
                    ConsumerGroupManager manager = this.getConsumer(event.getConsumerGroup());
                    if (Objects.isNull(manager)) {
                        return;
                    }
                    manager.getConsumerGroupConfig().getConsumerGroupTopicConf().put(event.getTopic(), event.getNewTopicConf());
                    break;
                }
                case CHANGE: {
                    ConsumerGroupManager manager = this.getConsumer(event.getConsumerGroup());
                    if (Objects.isNull(manager)) {
                        return;
                    }
                    manager.getConsumerGroupConfig().getConsumerGroupTopicConf().replace(event.getTopic(), event.getNewTopicConf());
                    break;
                }
                case DELETE: {
                    ConsumerGroupManager manager = this.getConsumer(event.getConsumerGroup());
                    if (Objects.isNull(manager)) {
                        return;
                    }
                    manager.getConsumerGroupConfig().getConsumerGroupTopicConf().remove(event.getTopic());
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error("onChange event:{} err", (Object)event, (Object)ex);
        }
    }

    @Subscribe
    public void handleConsumerGroupStateEvent(ConsumerGroupStateEvent event) {
        try {
            log.info("onChange event:{}", (Object)event);
            switch (event.getAction()) {
                case NEW: {
                    this.addConsumer(event.getConsumerGroup(), event.getConsumerGroupConfig());
                    break;
                }
                case CHANGE: {
                    this.restartConsumer(event.getConsumerGroup(), event.getConsumerGroupConfig());
                    break;
                }
                case DELETE: {
                    this.delConsumer(event.getConsumerGroup());
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error("onChange event:{} err", (Object)event, (Object)ex);
        }
    }

    public ConcurrentHashMap<String, ConsumerGroupManager> getClientTable() {
        return this.consumerTable;
    }
}

