/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodbyeTask
extends AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(GoodbyeTask.class);

    public GoodbyeTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        Package msg = new Package();
        try {
            if (this.pkg.getHeader().getCmd() == Command.SERVER_GOODBYE_RESPONSE) {
                log.info("client|address={}| has reject ", (Object)this.session.getContext().channel().remoteAddress());
            } else {
                msg.setHeader(new Header(Command.CLIENT_GOODBYE_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq()));
            }
        }
        catch (Exception e) {
            log.error("GoodbyeTask failed|user={}|errMsg={}", (Object)this.session.getClient(), (Object)e);
            msg.setHeader(new Header(Command.CLIENT_GOODBYE_RESPONSE, OPStatus.FAIL.getCode().intValue(), Arrays.toString(e.getStackTrace()), this.pkg.getHeader().getSeq()));
        }
        finally {
            this.eventMeshTCPServer.getScheduler().submit(() -> Utils.writeAndFlush(msg, this.startTime, taskExecuteTime, this.session.getContext(), this.session));
        }
        EventMeshTcp2Client.closeSessionIfTimeout(this.eventMeshTCPServer, this.session, this.eventMeshTCPServer.getClientSessionGroupMapping());
    }
}

