/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client;

import com.navercorp.pinpoint.common.util.StringJoiner;
import com.navercorp.pinpoint.grpc.Header;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class SupportCommandCodeClientInterceptor
implements ClientInterceptor {
    private final Set<Short> supportCommandCodes;

    public SupportCommandCodeClientInterceptor(Set<Short> supportCommandCodes) {
        this.supportCommandCodes = Objects.requireNonNull(supportCommandCodes, "supportCommandCodes");
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall clientCall = next.newCall(method, callOptions);
        ForwardingClientCall.SimpleForwardingClientCall forwardClientCall = new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                String supportCommandCode = SupportCommandCodeClientInterceptor.this.joinCommandCode(SupportCommandCodeClientInterceptor.this.supportCommandCodes, ";");
                headers.put(Header.SUPPORT_COMMAND_CODE, (Object)supportCommandCode);
                super.start(responseListener, headers);
            }
        };
        return forwardClientCall;
    }

    private String joinCommandCode(Collection<Short> supportCommandCodes, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (Short supportCommandCode : supportCommandCodes) {
            joiner.add(supportCommandCode.toString());
        }
        return joiner.toString();
    }
}

