/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.pravega;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.pravega.client.PravegaClient;
import org.apache.eventmesh.storage.pravega.config.PravegaStorageConfig;
import org.apache.eventmesh.storage.pravega.exception.PravegaStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config(field="pravegaConnectorConfig")
public class PravegaProducerImpl
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(PravegaProducerImpl.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private PravegaClient client;
    private PravegaStorageConfig pravegaConnectorConfig;

    public void init(Properties properties) throws Exception {
        this.client = PravegaClient.getInstance(this.pravegaConnectorConfig);
    }

    public void start() {
        this.started.compareAndSet(false, true);
    }

    public void shutdown() {
        this.started.compareAndSet(true, false);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.started.get();
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        try {
            SendResult sendResult = this.client.publish(cloudEvent.getSubject(), cloudEvent);
            sendCallback.onSuccess(sendResult);
        }
        catch (Exception e) {
            log.error("send message error, topic: {}", (Object)cloudEvent.getSubject());
            OnExceptionContext onExceptionContext = OnExceptionContext.builder().messageId("-1").topic(cloudEvent.getSubject()).exception(new StorageRuntimeException((Throwable)e)).build();
            sendCallback.onException(onExceptionContext);
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        this.client.publish(cloudEvent.getSubject(), cloudEvent);
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void checkTopicExist(String topic) throws Exception {
        if (!this.client.checkTopicExist(topic)) {
            throw new PravegaStorageException(String.format("topic:%s is not exist", topic));
        }
    }

    public void setExtFields() {
    }

    public PravegaStorageConfig getClientConfiguration() {
        return this.pravegaConnectorConfig;
    }
}

