/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.WebhookProtocolTransportObject;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.receive.ManufacturerProtocol;
import org.apache.eventmesh.webhook.receive.WebHookMQProducer;
import org.apache.eventmesh.webhook.receive.WebHookRequest;
import org.apache.eventmesh.webhook.receive.config.ReceiveConfiguration;
import org.apache.eventmesh.webhook.receive.protocol.ProtocolManager;
import org.apache.eventmesh.webhook.receive.storage.HookConfigOperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHookController {
    private static final Logger log = LoggerFactory.getLogger(WebHookController.class);
    private static final String PROTOCOL_ADAPTOR = "webhook";
    private static final String CONTENT_TYPE = "content-type";
    private static final String UUID_GENERATE_MODE = "uuid";
    private static final String DOT = ".";
    private final transient ProtocolManager protocolManager = new ProtocolManager();
    private transient HookConfigOperationManager hookConfigOperationManager;
    private transient WebHookMQProducer webHookMQProducer;
    private transient ProtocolAdaptor<ProtocolTransportObject> protocolAdaptor;
    private transient ReceiveConfiguration receiveConfiguration;

    public void init() throws Exception {
        this.receiveConfiguration = (ReceiveConfiguration)ConfigService.getInstance().buildConfigInstance(ReceiveConfiguration.class);
        Properties rootConfig = ConfigService.getInstance().getRootConfig();
        this.webHookMQProducer = new WebHookMQProducer(rootConfig, this.receiveConfiguration.getStoragePluginType());
        this.hookConfigOperationManager = new HookConfigOperationManager(this.receiveConfiguration);
        this.protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)PROTOCOL_ADAPTOR);
    }

    public void execute(String path, Map<String, String> header, byte[] body) throws Exception {
        WebHookConfig webHookConfig = new WebHookConfig();
        webHookConfig.setCallbackPath(path);
        webHookConfig = this.hookConfigOperationManager.queryWebHookConfigById(webHookConfig);
        if (webHookConfig == null) {
            throw new Exception("No matching webhookConfig.");
        }
        if (!Objects.equals(webHookConfig.getContentType(), header.get(CONTENT_TYPE))) {
            throw new Exception("http request header content-type value is mismatch. current value " + header.get(CONTENT_TYPE));
        }
        String manufacturerName = webHookConfig.getManufacturerName();
        ManufacturerProtocol protocol = this.protocolManager.getManufacturerProtocol(manufacturerName);
        WebHookRequest webHookRequest = new WebHookRequest();
        webHookRequest.setData(body);
        try {
            protocol.execute(webHookRequest, webHookConfig, header);
        }
        catch (Exception e) {
            throw new Exception("Webhook Message Parse Failed. " + e.getMessage(), e);
        }
        String cloudEventId = UUID_GENERATE_MODE.equals(webHookConfig.getCloudEventIdGenerateMode()) ? UUID.randomUUID().toString() : webHookRequest.getManufacturerEventId();
        String eventType = manufacturerName + DOT + webHookConfig.getManufacturerEventName();
        WebhookProtocolTransportObject webhookProtocolTransportObject = WebhookProtocolTransportObject.builder().cloudEventId(cloudEventId).eventType(eventType).cloudEventName(webHookConfig.getCloudEventName()).cloudEventSource("www." + webHookConfig.getManufacturerName() + ".com").dataContentType(webHookConfig.getDataContentType()).body(body).build();
        this.webHookMQProducer.send(this.protocolAdaptor.toCloudEvent((ProtocolTransportObject)webhookProtocolTransportObject), new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                if (log.isDebugEnabled()) {
                    log.debug(sendResult.toString());
                }
            }

            public void onException(OnExceptionContext context) {
                if (log.isWarnEnabled()) {
                    log.warn("", (Throwable)context.getException());
                }
            }
        });
    }
}

