/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.factory.StoragePluginFactory;
import org.apache.eventmesh.api.producer.Producer;

public class WebHookMQProducer {
    private transient Producer hookMQProducer;

    public WebHookMQProducer(Properties properties, String storagePluginType) throws Exception {
        this.hookMQProducer = StoragePluginFactory.getMeshMQProducer((String)storagePluginType);
        Objects.requireNonNull(this.hookMQProducer, "doesn't load the hookMQProducer plugin, please check.");
        this.hookMQProducer.init(properties);
    }

    public void send(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        Objects.requireNonNull(cloudEvent, "cloudEvent can not be null");
        this.hookMQProducer.publish(cloudEvent, sendCallback);
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        Objects.requireNonNull(cloudEvent, "cloudEvent can not be null");
        this.hookMQProducer.request(cloudEvent, rrCallback, timeout);
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        Objects.requireNonNull(cloudEvent, "cloudEvent can not be null");
        return this.hookMQProducer.reply(cloudEvent, sendCallback);
    }

    public Producer getHookMQProducer() {
        return this.hookMQProducer;
    }
}

