/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.lang;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BitConverter;
import lombok.Generated;

public class Int96
implements Comparable<Int96> {
    public static final Int96 ZERO = new Int96(0, 0L);
    private final int msb;
    private final long lsb;

    public Int96(int msb, long lsb) {
        Preconditions.checkArgument((msb >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((lsb >= 0L ? 1 : 0) != 0);
        this.msb = msb;
        this.lsb = lsb;
    }

    @Override
    public int compareTo(Int96 other) {
        if (this.msb != other.msb) {
            return Integer.compare(this.msb, other.msb);
        }
        return Long.compare(this.lsb, other.lsb);
    }

    public byte[] toBytes() {
        byte[] b = new byte[12];
        BitConverter.writeInt(b, 0, this.msb);
        BitConverter.writeLong(b, 4, this.lsb);
        return b;
    }

    public static Int96 fromBytes(byte[] b) {
        int msb = BitConverter.readInt(b, 0);
        long lsb = BitConverter.readLong(b, 4);
        return new Int96(msb, lsb);
    }

    public Int96 add(int increment) {
        Int96 retVal;
        Preconditions.checkArgument((increment >= 0 ? 1 : 0) != 0);
        if (this.lsb <= Long.MAX_VALUE - (long)increment) {
            retVal = new Int96(this.msb, this.lsb + (long)increment);
        } else if (this.msb < Integer.MAX_VALUE) {
            int remainder = increment - (int)(Long.MAX_VALUE - this.lsb);
            retVal = new Int96(this.msb + 1, remainder);
        } else {
            throw new ArithmeticException("Overflow");
        }
        return retVal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMsb() {
        return this.msb;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLsb() {
        return this.lsb;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Int96)) {
            return false;
        }
        Int96 other = (Int96)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMsb() != other.getMsb()) {
            return false;
        }
        return this.getLsb() == other.getLsb();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Int96;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMsb();
        long $lsb = this.getLsb();
        result = result * 59 + (int)($lsb >>> 32 ^ $lsb);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Int96(msb=" + this.getMsb() + ", lsb=" + this.getLsb() + ")";
    }
}

