/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.control;

import com.navercorp.pinpoint.rpc.control.ProtocolException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ControlMessageDecoder {
    private final Charset charset = StandardCharsets.UTF_8;

    public Object decode(byte[] in) throws ProtocolException {
        return this.decode(ByteBuffer.wrap(in));
    }

    public Object decode(ByteBuffer in) throws ProtocolException {
        byte type = in.get();
        switch (type) {
            case 78: {
                return null;
            }
            case 84: {
                return Boolean.TRUE;
            }
            case 70: {
                return Boolean.FALSE;
            }
            case 73: {
                return in.getInt();
            }
            case 76: {
                return in.getLong();
            }
            case 68: {
                return Double.longBitsToDouble(in.getLong());
            }
            case 83: {
                return this.decodeString(in);
            }
            case 86: {
                ArrayList<Object> answerList = new ArrayList<Object>();
                while (!this.isListFinished(in)) {
                    answerList.add(this.decode(in));
                }
                in.get();
                return answerList;
            }
            case 77: {
                LinkedHashMap<Object, Object> answerMap = new LinkedHashMap<Object, Object>();
                while (!this.isMapFinished(in)) {
                    Object key = this.decode(in);
                    Object value = this.decode(in);
                    answerMap.put(key, value);
                }
                in.get();
                return answerMap;
            }
        }
        throw new ProtocolException("invalid type character: " + (char)type + " (" + "0x" + Integer.toHexString(type) + ")");
    }

    private Object decodeString(ByteBuffer in) {
        int length = this.readStringLength(in);
        byte[] bytesToEncode = new byte[length];
        in.get(bytesToEncode);
        return new String(bytesToEncode, this.charset);
    }

    private boolean isMapFinished(ByteBuffer in) {
        return in.get(in.position()) == 122;
    }

    private boolean isListFinished(ByteBuffer in) {
        return in.get(in.position()) == 122;
    }

    private int readStringLength(ByteBuffer in) {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = in.get();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return result;
    }
}

