/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.IdValidateUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.rpc.packet.HandshakePropertyType;
import com.navercorp.pinpoint.rpc.server.ChannelProperties;
import com.navercorp.pinpoint.rpc.server.DefaultChannelProperties;
import com.navercorp.pinpoint.rpc.util.MapUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelPropertiesFactory {
    private final String[] customKey;

    public ChannelPropertiesFactory() {
        this.customKey = new String[0];
    }

    public ChannelPropertiesFactory(String customKeyList) {
        this.customKey = this.copy(customKeyList);
    }

    private String[] copy(String customKey) {
        if (StringUtils.isEmpty((String)customKey)) {
            return new String[0];
        }
        List keyList = StringUtils.tokenizeToStringList((String)customKey, (String)",");
        return keyList.toArray(new String[0]);
    }

    public ChannelProperties newChannelProperties(Map<Object, Object> properties) {
        if (com.navercorp.pinpoint.common.util.MapUtils.isEmpty(properties)) {
            return null;
        }
        String agentId = MapUtils.getString(properties, HandshakePropertyType.AGENT_ID.getName());
        if (!IdValidateUtils.validateId((String)agentId)) {
            throw new IllegalArgumentException("Invalid agentId :" + agentId);
        }
        String applicationName = MapUtils.getString(properties, HandshakePropertyType.APPLICATION_NAME.getName());
        if (!IdValidateUtils.validateId((String)applicationName)) {
            throw new IllegalArgumentException("Invalid applicationName :" + applicationName);
        }
        String hostName = MapUtils.getString(properties, HandshakePropertyType.HOSTNAME.getName());
        String ip = MapUtils.getString(properties, HandshakePropertyType.IP.getName());
        int pid = MapUtils.getInteger(properties, HandshakePropertyType.PID.getName(), -1);
        int serviceType = MapUtils.getInteger(properties, HandshakePropertyType.SERVICE_TYPE.getName(), -1);
        long startTime = MapUtils.getLong(properties, HandshakePropertyType.START_TIMESTAMP.getName(), -1L);
        String version = MapUtils.getString(properties, HandshakePropertyType.VERSION.getName());
        int socketId = MapUtils.getInteger(properties, "socketId", -1);
        List<Integer> supportCommandList = (List<Integer>)properties.get(HandshakePropertyType.SUPPORT_COMMAND_LIST.getName());
        if (supportCommandList == null) {
            supportCommandList = Collections.emptyList();
        }
        Map<Object, Object> customProperty = Collections.unmodifiableMap(this.copyCustomProperty(properties));
        return new DefaultChannelProperties(agentId, applicationName, serviceType, version, hostName, ip, pid, startTime, socketId, supportCommandList, customProperty);
    }

    private Map<Object, Object> copyCustomProperty(Map<Object, Object> properties) {
        if (ArrayUtils.isEmpty((Object[])this.customKey)) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (String key : this.customKey) {
            Object value = properties.get(key);
            if (value == null) continue;
            copy.put(key, value);
        }
        return copy;
    }
}

