/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.test.clientinterface.MQCollector;
import org.apache.rocketmq.test.util.TestUtil;

public class AbstractListener
extends MQCollector
implements MessageListener {
    public static Logger logger = Logger.getLogger(AbstractListener.class);
    protected boolean isDebug = false;
    protected String listenerName = null;
    protected Collection<Object> allSendMsgs = null;

    public AbstractListener() {
    }

    public AbstractListener(String listenerName) {
        this.listenerName = listenerName;
    }

    public AbstractListener(String originMsgCollector, String msgBodyCollector) {
        super(originMsgCollector, msgBodyCollector);
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    public void waitForMessageConsume(int timeoutMills) {
        TestUtil.waitForMonment(timeoutMills);
    }

    public void stopRecv() {
        super.lockCollectors();
    }

    public Collection<Object> waitForMessageConsume(Collection<Object> allSendMsgs, int timeoutMills) {
        this.allSendMsgs = allSendMsgs;
        ArrayList<Object> sendMsgs = new ArrayList<Object>();
        sendMsgs.addAll(allSendMsgs);
        long curTime = System.currentTimeMillis();
        while (!sendMsgs.isEmpty()) {
            Iterator iter = sendMsgs.iterator();
            while (iter.hasNext()) {
                Object msg = iter.next();
                if (!this.msgBodys.getAllData().contains(msg)) continue;
                iter.remove();
            }
            if (sendMsgs.isEmpty()) break;
            if (System.currentTimeMillis() - curTime >= (long)timeoutMills) {
                logger.error((Object)String.format("timeout but  [%s]  not recv all send messages!", this.listenerName));
                break;
            }
            logger.info((Object)String.format("[%s] still [%s] msg not recv!", this.listenerName, sendMsgs.size()));
            TestUtil.waitForMonment(500L);
        }
        return sendMsgs;
    }

    public long waitForMessageConsume(int size, int timeoutMills) {
        long curTime = System.currentTimeMillis();
        while (this.msgBodys.getDataSize() < (long)size) {
            if (System.currentTimeMillis() - curTime >= (long)timeoutMills) {
                logger.error((Object)String.format("timeout but  [%s]  not recv all send messages!", this.listenerName));
                break;
            }
            logger.info((Object)String.format("[%s] still [%s] msg not recv!", this.listenerName, (long)size - this.msgBodys.getDataSize()));
            TestUtil.waitForMonment(500L);
        }
        return this.msgBodys.getDataSize();
    }

    public void waitForMessageConsume(Map<Object, Object> sendMsgIndex, int timeoutMills) {
        Collection<Object> notRecvMsgs = this.waitForMessageConsume(sendMsgIndex.keySet(), timeoutMills);
        for (Object object : notRecvMsgs) {
            logger.info(sendMsgIndex.get(object));
        }
    }
}

