/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.mongodb.consumer;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.mongodb.config.ConfigurationHolder;
import org.apache.eventmesh.storage.mongodb.consumer.MongodbReplicaSetConsumer;
import org.apache.eventmesh.storage.mongodb.consumer.MongodbStandaloneConsumer;

@Config(field="configurationHolder")
public class MongodbConsumer
implements Consumer {
    private ConfigurationHolder configurationHolder;
    private Consumer consumer;

    public boolean isStarted() {
        return this.consumer.isStarted();
    }

    public boolean isClosed() {
        return this.consumer.isClosed();
    }

    public void start() {
        this.consumer.start();
    }

    public void shutdown() {
        this.consumer.shutdown();
    }

    public void init(Properties keyValue) throws Exception {
        String connectorType = this.configurationHolder.getConnectorType();
        if (connectorType.equals("STANDALONE")) {
            this.consumer = new MongodbStandaloneConsumer(this.configurationHolder);
        }
        if (connectorType.equals("REPLICA_SET")) {
            this.consumer = new MongodbReplicaSetConsumer(this.configurationHolder);
        }
        this.consumer.init(keyValue);
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        this.consumer.updateOffset(cloudEvents, context);
    }

    public void subscribe(String topic) throws Exception {
        this.consumer.subscribe(topic);
    }

    public void unsubscribe(String topic) {
        this.consumer.unsubscribe(topic);
    }

    public void registerEventListener(EventListener listener) {
        this.consumer.registerEventListener(listener);
    }
}

