/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.mongodb.producer;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.storage.mongodb.client.MongodbClientManager;
import org.apache.eventmesh.storage.mongodb.config.ConfigurationHolder;
import org.apache.eventmesh.storage.mongodb.exception.MongodbStorageException;
import org.apache.eventmesh.storage.mongodb.utils.MongodbCloudEventUtil;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbReplicaSetProducer
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(MongodbReplicaSetProducer.class);
    private volatile boolean started = false;
    private final ConfigurationHolder configurationHolder;
    private MongoClient mongoClient;

    public MongodbReplicaSetProducer(ConfigurationHolder configurationHolder) {
        this.configurationHolder = configurationHolder;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public void shutdown() {
        if (this.started) {
            try {
                if (this.mongoClient != null) {
                    MongodbClientManager.closeMongodbClient(this.mongoClient);
                }
            }
            finally {
                this.started = false;
            }
        }
    }

    public void init(Properties properties) {
        this.mongoClient = MongodbClientManager.createMongodbClient(this.configurationHolder.getUrl());
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) {
        try {
            Document document = MongodbCloudEventUtil.convertToDocument(cloudEvent);
            MongoCollection collection = this.mongoClient.getDatabase(this.configurationHolder.getDatabase()).getCollection(this.configurationHolder.getCollection());
            collection.insertOne((Object)document);
            SendResult sendResult = new SendResult();
            sendResult.setTopic(cloudEvent.getSubject());
            sendResult.setMessageId(cloudEvent.getId());
            sendCallback.onSuccess(sendResult);
        }
        catch (Exception ex) {
            log.error("[MongodbReplicaSetProducer] publish happen exception.", (Throwable)ex);
            sendCallback.onException(OnExceptionContext.builder().topic(cloudEvent.getSubject()).messageId(cloudEvent.getId()).exception((StorageRuntimeException)new MongodbStorageException(ex)).build());
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        try {
            Document document = MongodbCloudEventUtil.convertToDocument(cloudEvent);
            MongoCollection collection = this.mongoClient.getDatabase(this.configurationHolder.getDatabase()).getCollection(this.configurationHolder.getCollection());
            collection.insertOne((Object)document);
        }
        catch (Exception ex) {
            log.error("[MongodbReplicaSetProducer] sendOneway happen exception.", (Throwable)ex);
        }
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) {
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) {
        return false;
    }

    public void checkTopicExist(String topic) {
    }

    public void setExtFields() {
    }
}

