/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.webhook;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.WebhookProtocolTransportObject;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class WebHookProtocolAdaptor
implements ProtocolAdaptor<WebhookProtocolTransportObject> {
    public CloudEvent toCloudEvent(WebhookProtocolTransportObject protocol) throws ProtocolHandleException {
        return ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(protocol.getCloudEventId()).withSubject(protocol.getCloudEventName()).withSource(URI.create(protocol.getCloudEventSource())).withDataContentType(protocol.getDataContentType()).withType(protocol.getEventType()).withData(protocol.getBody())).withExtension("protocoltype", "webhook")).withExtension("bizseqno", RandomStringUtils.generateNum((int)30))).withExtension("uniqueid", RandomStringUtils.generateNum((int)30))).build();
    }

    public List<CloudEvent> toBatchCloudEvent(WebhookProtocolTransportObject protocol) {
        return new ArrayList<CloudEvent>();
    }

    public ProtocolTransportObject fromCloudEvent(CloudEvent cloudEvent) {
        HttpEventWrapper httpEventWrapper = new HttpEventWrapper();
        HashMap<String, Object> sysHeaderMap = new HashMap<String, Object>();
        Set attributeNames = cloudEvent.getAttributeNames();
        Set extensionNames = cloudEvent.getExtensionNames();
        for (String attributeName : attributeNames) {
            sysHeaderMap.put(attributeName, cloudEvent.getAttribute(attributeName));
        }
        for (String extensionName : extensionNames) {
            sysHeaderMap.put(extensionName, cloudEvent.getExtension(extensionName));
        }
        sysHeaderMap.put("cloudEventId", cloudEvent.getId());
        sysHeaderMap.put("cloudEventName", cloudEvent.getSubject());
        sysHeaderMap.put("cloudEventSource", cloudEvent.getSource().toString());
        sysHeaderMap.put("type", cloudEvent.getType());
        httpEventWrapper.setSysHeaderMap(sysHeaderMap);
        if (cloudEvent.getData() != null) {
            httpEventWrapper.setBody(cloudEvent.getData().toBytes());
        }
        return httpEventWrapper;
    }

    public String getProtocolType() {
        return "webhookProtocolAdaptor";
    }
}

