/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public class SegmentWithRange {
    @NonNull
    private final Segment segment;
    private final Range range;

    public SegmentWithRange(Segment segment, double rangeLow, double rangeHigh) {
        this(segment, new Range(rangeLow, rangeHigh));
    }

    public SegmentWithRange(Segment segment, Range range) {
        Preconditions.checkNotNull((Object)segment);
        if (range != null) {
            Preconditions.checkArgument((range.low >= 0.0 && range.low <= 1.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((range.high >= 0.0 && range.high <= 1.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((range.low <= range.high ? 1 : 0) != 0);
        }
        this.segment = segment;
        this.range = range;
    }

    public io.pravega.shared.watermarks.SegmentWithRange convert() {
        return new io.pravega.shared.watermarks.SegmentWithRange(this.getSegment().getSegmentId(), this.getRange().low, this.getRange().high);
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Segment getSegment() {
        return this.segment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Range getRange() {
        return this.range;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SegmentWithRange(segment=" + this.getSegment() + ", range=" + this.getRange() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentWithRange)) {
            return false;
        }
        SegmentWithRange other = (SegmentWithRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Segment this$segment = this.getSegment();
        Segment other$segment = other.getSegment();
        return !(this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentWithRange;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Segment $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
        return result;
    }

    public static final class Range {
        private final double low;
        private final double high;

        public static Range fromPair(Pair<Double, Double> pair) {
            return new Range((Double)pair.getLeft(), (Double)pair.getRight());
        }

        public Pair<Double, Double> asPair() {
            return Pair.of((Object)this.low, (Object)this.high);
        }

        public boolean overlapsWith(Range other) {
            return !(this.high <= other.low) && !(this.low >= other.high);
        }

        @ConstructorProperties(value={"low", "high"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Range(double low, double high) {
            this.low = low;
            this.high = high;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public double getLow() {
            return this.low;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public double getHigh() {
            return this.high;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (Double.compare(this.getLow(), other.getLow()) != 0) {
                return false;
            }
            return Double.compare(this.getHigh(), other.getHigh()) == 0;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $low = Double.doubleToLongBits(this.getLow());
            result = result * 59 + (int)($low >>> 32 ^ $low);
            long $high = Double.doubleToLongBits(this.getHigh());
            result = result * 59 + (int)($high >>> 32 ^ $high);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SegmentWithRange.Range(low=" + this.getLow() + ", high=" + this.getHigh() + ")";
        }
    }
}

