/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaData;
import com.navercorp.pinpoint.bootstrap.context.ServiceInfo;
import com.navercorp.pinpoint.profiler.context.DefaultServerMetaData;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultServerMetaDataRegistryService
implements ServerMetaDataRegistryService {
    private final List<ServerMetaDataRegistryService.OnChangeListener> listeners = new CopyOnWriteArrayList<ServerMetaDataRegistryService.OnChangeListener>();
    private volatile String serverName;
    private final List<String> vmArgs;
    private final Map<Integer, String> connectors = new ConcurrentHashMap<Integer, String>();
    private final Queue<ServiceInfo> serviceInfos = new ConcurrentLinkedQueue<ServiceInfo>();

    public DefaultServerMetaDataRegistryService(List<String> vmArgs) {
        this.vmArgs = Collections.unmodifiableList(vmArgs);
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public void addConnector(String protocol, int port) {
        this.connectors.put(port, protocol);
    }

    @Override
    public void addServiceInfo(ServiceInfo serviceInfo) {
        this.serviceInfos.add(serviceInfo);
    }

    @Override
    public ServerMetaData getServerMetaData() {
        return this.createServerMetaData();
    }

    @Override
    public boolean addListener(ServerMetaDataRegistryService.OnChangeListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ServerMetaDataRegistryService.OnChangeListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    @Override
    public void notifyListeners() {
        for (ServerMetaDataRegistryService.OnChangeListener listener : this.listeners) {
            listener.onServerMetaDataChange();
        }
    }

    private ServerMetaData createServerMetaData() {
        String serverName = this.serverName == null ? "" : this.serverName;
        ArrayList<String> vmArgs = this.vmArgs == null ? Collections.emptyList() : new ArrayList<String>(this.vmArgs);
        HashMap<Integer, String> connectors = this.connectors.isEmpty() ? Collections.emptyMap() : new HashMap<Integer, String>(this.connectors);
        ArrayList<ServiceInfo> serviceInfos = this.serviceInfos.isEmpty() ? Collections.emptyList() : new ArrayList<ServiceInfo>(this.serviceInfos);
        return new DefaultServerMetaData(serverName, vmArgs, connectors, serviceInfos);
    }
}

