/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.grpc.trace.PActiveTrace;
import com.navercorp.pinpoint.grpc.trace.PActiveTraceHistogram;
import com.navercorp.pinpoint.grpc.trace.PAgentStat;
import com.navercorp.pinpoint.grpc.trace.PAgentStatBatch;
import com.navercorp.pinpoint.grpc.trace.PAgentUriStat;
import com.navercorp.pinpoint.grpc.trace.PCpuLoad;
import com.navercorp.pinpoint.grpc.trace.PCustomMetricMessage;
import com.navercorp.pinpoint.grpc.trace.PDataSource;
import com.navercorp.pinpoint.grpc.trace.PDataSourceList;
import com.navercorp.pinpoint.grpc.trace.PDeadlock;
import com.navercorp.pinpoint.grpc.trace.PDirectBuffer;
import com.navercorp.pinpoint.grpc.trace.PFileDescriptor;
import com.navercorp.pinpoint.grpc.trace.PJvmGc;
import com.navercorp.pinpoint.grpc.trace.PJvmGcDetailed;
import com.navercorp.pinpoint.grpc.trace.PJvmGcType;
import com.navercorp.pinpoint.grpc.trace.PLoadedClass;
import com.navercorp.pinpoint.grpc.trace.PResponseTime;
import com.navercorp.pinpoint.grpc.trace.PThreadDump;
import com.navercorp.pinpoint.grpc.trace.PTotalThread;
import com.navercorp.pinpoint.grpc.trace.PTransaction;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogramUtils;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcCustomMetricMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcJvmGcTypeMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcThreadDumpMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcUriStatMessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentCustomMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcDetailedMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSource;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.FileDescriptorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.loadedclass.LoadedClassMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeValue;
import com.navercorp.pinpoint.profiler.monitor.metric.totalthread.TotalThreadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.transaction.TransactionMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import java.util.List;

public class GrpcStatMessageConverter
implements MessageConverter<MetricType, GeneratedMessageV3> {
    private final MessageConverter<Object, PThreadDump> threadDumpMessageConverter = new GrpcThreadDumpMessageConverter();
    private final MessageConverter<Object, PJvmGcType> jvmGcTypeConverter = new GrpcJvmGcTypeMessageConverter();
    private final MessageConverter<MetricType, PCustomMetricMessage> customMetricMessageConverter = new GrpcCustomMetricMessageConverter();
    private final MessageConverter<MetricType, PAgentUriStat> uriStatMessageConverter = new GrpcUriStatMessageConverter();

    @Override
    public GeneratedMessageV3 toMessage(MetricType message) {
        if (message instanceof AgentStatMetricSnapshotBatch) {
            AgentStatMetricSnapshotBatch agentStatMetricSnapshotBatch = (AgentStatMetricSnapshotBatch)message;
            PAgentStatBatch.Builder agentStatBatchBuilder = PAgentStatBatch.newBuilder();
            for (AgentStatMetricSnapshot agentStatMetricSnapshot : agentStatMetricSnapshotBatch.getAgentStats()) {
                PAgentStat agentStat = this.converAgentStat(agentStatMetricSnapshot);
                agentStatBatchBuilder.addAgentStat(agentStat);
            }
            return agentStatBatchBuilder.build();
        }
        if (message instanceof AgentStatMetricSnapshot) {
            AgentStatMetricSnapshot agentStatMetricSnapshot = (AgentStatMetricSnapshot)message;
            PAgentStat agentStat = this.converAgentStat(agentStatMetricSnapshot);
            return agentStat;
        }
        if (message instanceof AgentCustomMetricSnapshotBatch) {
            AgentCustomMetricSnapshotBatch agentCustomMetricSnapshotBatch = (AgentCustomMetricSnapshotBatch)message;
            PCustomMetricMessage pCustomMetricMessage = this.customMetricMessageConverter.toMessage(agentCustomMetricSnapshotBatch);
            return pCustomMetricMessage;
        }
        if (message instanceof AgentUriStatData) {
            AgentUriStatData agentUriStatData = (AgentUriStatData)message;
            PAgentUriStat agentUriStat = this.uriStatMessageConverter.toMessage(agentUriStatData);
            return agentUriStat;
        }
        return null;
    }

    private PAgentStat converAgentStat(AgentStatMetricSnapshot agentStatMetricSnapshot) {
        LoadedClassMetricSnapshot loadedClassMetricSnapshot;
        TotalThreadMetricSnapshot totalThreadMetricSnapshot;
        BufferMetricSnapshot bufferMetricSnapshot;
        FileDescriptorMetricSnapshot fileDescriptorMetricSnapshot;
        DeadlockMetricSnapshot deadlockMetricSnapshot;
        ResponseTimeValue responseTimeValue;
        DataSourceMetricSnapshot dataSourceMetricSnapshot;
        ActiveTraceHistogram activeTraceHistogram;
        TransactionMetricSnapshot transactionMetricSnapshot;
        CpuLoadMetricSnapshot cpuLoadMetricSnapshot;
        PAgentStat.Builder agentStatBuilder = PAgentStat.newBuilder();
        agentStatBuilder.setTimestamp(agentStatMetricSnapshot.getTimestamp());
        agentStatBuilder.setCollectInterval(agentStatMetricSnapshot.getCollectInterval());
        JvmGcMetricSnapshot jvmGcMetricSnapshot = agentStatMetricSnapshot.getGc();
        if (jvmGcMetricSnapshot != null) {
            PJvmGc jvmGc = this.convertJvmGc(jvmGcMetricSnapshot);
            agentStatBuilder.setGc(jvmGc);
        }
        if ((cpuLoadMetricSnapshot = agentStatMetricSnapshot.getCpuLoad()) != null) {
            PCpuLoad cpuLoad = this.convertCpuLoad(cpuLoadMetricSnapshot);
            agentStatBuilder.setCpuLoad(cpuLoad);
        }
        if ((transactionMetricSnapshot = agentStatMetricSnapshot.getTransaction()) != null) {
            PTransaction transaction = this.convertTransaction(transactionMetricSnapshot);
            agentStatBuilder.setTransaction(transaction);
        }
        if ((activeTraceHistogram = agentStatMetricSnapshot.getActiveTrace()) != null) {
            PActiveTrace activeTrace = this.convertActiveTrace(activeTraceHistogram);
            agentStatBuilder.setActiveTrace(activeTrace);
        }
        if ((dataSourceMetricSnapshot = agentStatMetricSnapshot.getDataSourceList()) != null) {
            PDataSourceList dataSourceList = this.convertDataSourceList(dataSourceMetricSnapshot);
            agentStatBuilder.setDataSourceList(dataSourceList);
        }
        if ((responseTimeValue = agentStatMetricSnapshot.getResponseTime()) != null) {
            PResponseTime responseTime = this.convertResponseTime(responseTimeValue);
            agentStatBuilder.setResponseTime(responseTime);
        }
        if ((deadlockMetricSnapshot = agentStatMetricSnapshot.getDeadlock()) != null) {
            PDeadlock deadlock = this.convertDeadlock(deadlockMetricSnapshot);
            agentStatBuilder.setDeadlock(deadlock);
        }
        if ((fileDescriptorMetricSnapshot = agentStatMetricSnapshot.getFileDescriptor()) != null) {
            PFileDescriptor fileDescriptor = this.convertFileDescriptor(fileDescriptorMetricSnapshot);
            agentStatBuilder.setFileDescriptor(fileDescriptor);
        }
        if ((bufferMetricSnapshot = agentStatMetricSnapshot.getDirectBuffer()) != null) {
            PDirectBuffer directBuffer = this.convertDirectBuffer(bufferMetricSnapshot);
            agentStatBuilder.setDirectBuffer(directBuffer);
        }
        if ((totalThreadMetricSnapshot = agentStatMetricSnapshot.getTotalThread()) != null) {
            PTotalThread totalThread = this.convertTotalThread(totalThreadMetricSnapshot);
            agentStatBuilder.setTotalThread(totalThread);
        }
        if ((loadedClassMetricSnapshot = agentStatMetricSnapshot.getLoadedClassCount()) != null) {
            PLoadedClass loadedClass = this.convertLoadedClass(loadedClassMetricSnapshot);
            agentStatBuilder.setLoadedClass(loadedClass);
        }
        return agentStatBuilder.build();
    }

    private PJvmGc convertJvmGc(JvmGcMetricSnapshot jvmGcMetricSnapshot) {
        PJvmGc.Builder jvmGcBuilder = PJvmGc.newBuilder();
        jvmGcBuilder.setJvmMemoryHeapMax(jvmGcMetricSnapshot.getJvmMemoryHeapMax());
        jvmGcBuilder.setJvmMemoryHeapUsed(jvmGcMetricSnapshot.getJvmMemoryHeapUsed());
        jvmGcBuilder.setJvmMemoryNonHeapMax(jvmGcMetricSnapshot.getJvmMemoryNonHeapMax());
        jvmGcBuilder.setJvmMemoryNonHeapUsed(jvmGcMetricSnapshot.getJvmMemoryNonHeapUsed());
        jvmGcBuilder.setJvmGcOldCount(jvmGcMetricSnapshot.getJvmGcOldCount());
        jvmGcBuilder.setJvmGcOldTime(jvmGcMetricSnapshot.getJvmGcOldTime());
        PJvmGcType jvmGcType = this.jvmGcTypeConverter.toMessage((Object)jvmGcMetricSnapshot.getType());
        jvmGcBuilder.setType(jvmGcType);
        if (jvmGcMetricSnapshot.getJvmGcDetailed() != null) {
            JvmGcDetailedMetricSnapshot jvmGcDetailedMetricSnapshot = jvmGcMetricSnapshot.getJvmGcDetailed();
            PJvmGcDetailed.Builder jvmGcDetailedBuilder = PJvmGcDetailed.newBuilder();
            jvmGcDetailedBuilder.setJvmPoolNewGenUsed(jvmGcDetailedMetricSnapshot.getJvmPoolNewGenUsed());
            jvmGcDetailedBuilder.setJvmPoolOldGenUsed(jvmGcDetailedMetricSnapshot.getJvmPoolOldGenUsed());
            jvmGcDetailedBuilder.setJvmPoolSurvivorSpaceUsed(jvmGcDetailedMetricSnapshot.getJvmPoolSurvivorSpaceUsed());
            jvmGcDetailedBuilder.setJvmPoolCodeCacheUsed(jvmGcDetailedMetricSnapshot.getJvmPoolCodeCacheUsed());
            jvmGcDetailedBuilder.setJvmPoolPermGenUsed(jvmGcDetailedMetricSnapshot.getJvmPoolPermGenUsed());
            jvmGcDetailedBuilder.setJvmPoolMetaspaceUsed(jvmGcDetailedMetricSnapshot.getJvmPoolMetaspaceUsed());
            jvmGcDetailedBuilder.setJvmGcNewCount(jvmGcDetailedMetricSnapshot.getJvmGcNewCount());
            jvmGcDetailedBuilder.setJvmGcNewTime(jvmGcDetailedMetricSnapshot.getJvmGcNewTime());
            jvmGcBuilder.setJvmGcDetailed(jvmGcDetailedBuilder.build());
        }
        return jvmGcBuilder.build();
    }

    private PCpuLoad convertCpuLoad(CpuLoadMetricSnapshot cpuLoadMetricSnapshot) {
        PCpuLoad.Builder cpuLoadBuilder = PCpuLoad.newBuilder();
        cpuLoadBuilder.setJvmCpuLoad(cpuLoadMetricSnapshot.getJvmCpuUsage());
        cpuLoadBuilder.setSystemCpuLoad(cpuLoadMetricSnapshot.getSystemCpuUsage());
        return cpuLoadBuilder.build();
    }

    private PTransaction convertTransaction(TransactionMetricSnapshot transactionMetricSnapshot) {
        PTransaction.Builder transactionBuilder = PTransaction.newBuilder();
        transactionBuilder.setSampledNewCount(transactionMetricSnapshot.getSampledNewCount());
        transactionBuilder.setSampledContinuationCount(transactionMetricSnapshot.getSampledContinuationCount());
        transactionBuilder.setUnsampledNewCount(transactionMetricSnapshot.getUnsampledNewCount());
        transactionBuilder.setUnsampledContinuationCount(transactionMetricSnapshot.getUnsampledContinuationCount());
        transactionBuilder.setSkippedNewCount(transactionMetricSnapshot.getSkippedNewCount());
        transactionBuilder.setSkippedContinuationCount(transactionMetricSnapshot.getSkippedContinuationCount());
        return transactionBuilder.build();
    }

    private PActiveTrace convertActiveTrace(ActiveTraceHistogram activeTraceHistogram) {
        PActiveTrace.Builder activeTraceBuilder = PActiveTrace.newBuilder();
        PActiveTraceHistogram.Builder activeTraceHistogramBuilder = PActiveTraceHistogram.newBuilder();
        if (activeTraceHistogram.getHistogramSchema() != null) {
            activeTraceHistogramBuilder.setHistogramSchemaType(activeTraceHistogram.getHistogramSchema().getTypeCode());
        }
        List<Integer> activeTraceCounts = ActiveTraceHistogramUtils.asList(activeTraceHistogram);
        activeTraceHistogramBuilder.addAllActiveTraceCount(activeTraceCounts);
        activeTraceBuilder.setHistogram(activeTraceHistogramBuilder.build());
        return activeTraceBuilder.build();
    }

    private PDataSourceList convertDataSourceList(DataSourceMetricSnapshot dataSourceMetricSnapshot) {
        PDataSourceList.Builder dataSourceListBuilder = PDataSourceList.newBuilder();
        for (DataSource dataSourceCollectData : dataSourceMetricSnapshot.getDataSourceList()) {
            PDataSource.Builder dataSourceBuilder = PDataSource.newBuilder();
            dataSourceBuilder.setId(dataSourceCollectData.getId());
            dataSourceBuilder.setServiceTypeCode((int)dataSourceCollectData.getServiceTypeCode());
            if (dataSourceCollectData.getDatabaseName() != null) {
                dataSourceBuilder.setDatabaseName(dataSourceCollectData.getDatabaseName());
            }
            if (dataSourceCollectData.getActiveConnectionSize() != 0) {
                dataSourceBuilder.setActiveConnectionSize(dataSourceCollectData.getActiveConnectionSize());
            }
            if (dataSourceCollectData.getUrl() != null) {
                dataSourceBuilder.setUrl(dataSourceCollectData.getUrl());
            }
            dataSourceBuilder.setMaxConnectionSize(dataSourceCollectData.getMaxConnectionSize());
            dataSourceListBuilder.addDataSource(dataSourceBuilder.build());
        }
        return dataSourceListBuilder.build();
    }

    private PResponseTime convertResponseTime(ResponseTimeValue responseTimeCollectData) {
        PResponseTime.Builder responseTime = PResponseTime.newBuilder();
        if (responseTimeCollectData.getAvg() != 0L) {
            responseTime.setAvg(responseTimeCollectData.getAvg());
        }
        if (responseTimeCollectData.getMax() != 0L) {
            responseTime.setMax(responseTimeCollectData.getMax());
        }
        return responseTime.build();
    }

    private PDeadlock convertDeadlock(DeadlockMetricSnapshot deadlockMetricSnapshot) {
        PDeadlock.Builder deadlockBuilder = PDeadlock.newBuilder();
        deadlockBuilder.setCount(deadlockMetricSnapshot.getDeadlockedThreadCount());
        for (ThreadDumpMetricSnapshot threadDumpMetricSnapshot : deadlockMetricSnapshot.getDeadlockedThreadList()) {
            PThreadDump threadDump = this.threadDumpMessageConverter.toMessage(threadDumpMetricSnapshot);
            if (threadDump == null) continue;
            deadlockBuilder.addThreadDump(threadDump);
        }
        return deadlockBuilder.build();
    }

    private PFileDescriptor convertFileDescriptor(FileDescriptorMetricSnapshot fileDescriptorCollectData) {
        PFileDescriptor.Builder fileDescriptorBuilder = PFileDescriptor.newBuilder();
        fileDescriptorBuilder.setOpenFileDescriptorCount(fileDescriptorCollectData.getOpenFileDescriptorCount());
        return fileDescriptorBuilder.build();
    }

    private PDirectBuffer convertDirectBuffer(BufferMetricSnapshot directBufferCollectData) {
        PDirectBuffer.Builder directBufferBuilder = PDirectBuffer.newBuilder();
        directBufferBuilder.setDirectCount(directBufferCollectData.getDirectCount());
        directBufferBuilder.setDirectMemoryUsed(directBufferCollectData.getDirectMemoryUsed());
        directBufferBuilder.setMappedCount(directBufferCollectData.getMappedCount());
        directBufferBuilder.setMappedMemoryUsed(directBufferCollectData.getMappedMemoryUsed());
        return directBufferBuilder.build();
    }

    private PTotalThread convertTotalThread(TotalThreadMetricSnapshot totalThreadCountData) {
        PTotalThread.Builder totalThreadBuilder = PTotalThread.newBuilder();
        totalThreadBuilder.setTotalThreadCount((long)totalThreadCountData.getTotalThreadCount());
        return totalThreadBuilder.build();
    }

    private PLoadedClass convertLoadedClass(LoadedClassMetricSnapshot loadedClassCountData) {
        PLoadedClass.Builder loadedClassBuilder = PLoadedClass.newBuilder();
        loadedClassBuilder.setLoadedClassCount((long)loadedClassCountData.getLoadedClassCount());
        loadedClassBuilder.setUnloadedClassCount(loadedClassCountData.getUnloadedClassCount());
        return loadedClassBuilder.build();
    }
}

