/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.plugin;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.module.PluginJarPaths;
import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.config.PluginLoadingConfig;
import com.navercorp.pinpoint.profiler.plugin.filter.DefaultPluginFilterFactory;
import com.navercorp.pinpoint.profiler.plugin.filter.ImportPluginFilterFactory;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginJarsProvider
implements Provider<List<PluginJar>> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final List<PluginJar> pluginJars;

    @Inject
    public PluginJarsProvider(@PluginJarPaths List<String> pluginJarPaths, PluginLoadingConfig pluginLoadingConfig) {
        Objects.requireNonNull(pluginJarPaths, "pluginJarPaths");
        Objects.requireNonNull(pluginLoadingConfig, "pluginLoadingConfig");
        PluginFilter pluginFilter = this.createPluginJarFilter(pluginLoadingConfig);
        this.logger.info("pluginJarFilter:{}", (Object)pluginFilter);
        List<PluginJar> pluginJars = this.createPluginJars(pluginJarPaths, pluginFilter, pluginLoadingConfig.getPluginLoadOrder());
        this.pluginJars = Collections.unmodifiableList(pluginJars);
    }

    public List<PluginJar> get() {
        return this.pluginJars;
    }

    private List<PluginJar> createPluginJars(List<String> pluginJarPaths, PluginFilter pluginFilter, List<String> orderedPluginIdList) {
        if (CollectionUtils.isEmpty(pluginJarPaths)) {
            return Collections.emptyList();
        }
        List<PluginJar> pluginList = this.filter(pluginJarPaths, pluginFilter);
        return this.sort(pluginList, orderedPluginIdList);
    }

    private List<PluginJar> sort(List<PluginJar> pluginList, List<String> orderedPluginIdList) {
        Map<String, PluginJar> orderedPlugins = this.getOrderedPlugins(orderedPluginIdList);
        ArrayList<PluginJar> unorderedPlugins = new ArrayList<PluginJar>();
        for (PluginJar pluginJar : pluginList) {
            String pluginId = pluginJar.getPluginId();
            if (orderedPlugins.containsKey(pluginId)) {
                PluginJar prev = orderedPlugins.put(pluginId, pluginJar);
                if (prev == null) continue;
                throw new IllegalStateException("Duplicate order found for plugin : " + pluginId);
            }
            unorderedPlugins.add(pluginJar);
        }
        ArrayList<PluginJar> pluginJars = new ArrayList<PluginJar>();
        for (PluginJar orderedPlugin : orderedPlugins.values()) {
            if (orderedPlugin == null) continue;
            pluginJars.add(orderedPlugin);
        }
        pluginJars.addAll(unorderedPlugins);
        return pluginJars;
    }

    private List<PluginJar> filter(List<String> pluginJarPaths, PluginFilter pluginFilter) {
        ArrayList<PluginJar> list = new ArrayList<PluginJar>();
        for (String pluginJarPath : pluginJarPaths) {
            PluginJar pluginJar = PluginJar.fromFilePath(pluginJarPath);
            if (!pluginFilter.accept(pluginJar)) continue;
            list.add(pluginJar);
        }
        return list;
    }

    private Map<String, PluginJar> getOrderedPlugins(List<String> orderedPluginIdList) {
        if (CollectionUtils.isEmpty(orderedPluginIdList)) {
            return new LinkedHashMap<String, PluginJar>();
        }
        LinkedHashMap<String, PluginJar> orderedPlugins = new LinkedHashMap<String, PluginJar>();
        for (String orderedPluginId : orderedPluginIdList) {
            orderedPlugins.put(orderedPluginId, null);
        }
        return orderedPlugins;
    }

    private PluginFilter createPluginJarFilter(PluginLoadingConfig pluginLoadingConfig) {
        List<String> importPluginIds = pluginLoadingConfig.getImportPluginIds();
        if (CollectionUtils.hasLength(importPluginIds)) {
            ImportPluginFilterFactory filterFactory = new ImportPluginFilterFactory(importPluginIds);
            return filterFactory.newPluginFilter();
        }
        DefaultPluginFilterFactory filterFactory = new DefaultPluginFilterFactory(pluginLoadingConfig);
        return filterFactory.newPluginFilter();
    }
}

