/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.plugin;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.module.ConfiguredApplicationType;
import com.navercorp.pinpoint.profiler.context.module.PluginJars;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjectorFactory;
import com.navercorp.pinpoint.profiler.plugin.DefaultProfilerPluginContextLoader;
import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.PluginSetup;
import com.navercorp.pinpoint.profiler.plugin.ProfilerPluginContextLoader;
import com.navercorp.pinpoint.profiler.plugin.config.PluginLoadingConfig;
import java.util.List;
import java.util.Objects;

public class ProfilerPluginContextLoaderProvider
implements Provider<ProfilerPluginContextLoader> {
    private final ProfilerConfig profilerConfig;
    private final PluginLoadingConfig pluginLoadingConfig;
    private final ServiceType configuredApplicationType;
    private final PluginSetup pluginSetup;
    private final ClassInjectorFactory classInjectorFactory;
    private final List<PluginJar> pluginJars;

    @Inject
    public ProfilerPluginContextLoaderProvider(ProfilerConfig profilerConfig, PluginLoadingConfig pluginLoadingConfig, @ConfiguredApplicationType ServiceType configuredApplicationType, PluginSetup pluginSetup, InstrumentEngine instrumentEngine, BootstrapCore bootstrapCore, @PluginJars List<PluginJar> pluginJars) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.pluginLoadingConfig = Objects.requireNonNull(pluginLoadingConfig, "pluginLoadingConfig");
        this.configuredApplicationType = Objects.requireNonNull(configuredApplicationType, "configuredApplicationType");
        this.pluginSetup = Objects.requireNonNull(pluginSetup, "pluginSetup");
        Objects.requireNonNull(instrumentEngine, "instrumentEngine");
        Objects.requireNonNull(bootstrapCore, "bootstrapCore");
        this.classInjectorFactory = new ClassInjectorFactory(instrumentEngine, bootstrapCore);
        this.pluginJars = Objects.requireNonNull(pluginJars, "pluginJars");
    }

    public ProfilerPluginContextLoader get() {
        return new DefaultProfilerPluginContextLoader(this.profilerConfig, this.pluginLoadingConfig, this.configuredApplicationType, this.classInjectorFactory, this.pluginSetup, this.pluginJars);
    }
}

