/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.ResultResponse;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.io.DeserializerFactory;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializerFactory;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;
import org.apache.thrift.TBase;

public class ThriftMessageToResultConverter
implements MessageConverter<Object, ResultResponse> {
    @Override
    public ResultResponse toMessage(Object object) {
        if (object instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)object;
            byte[] byteMessage = responseMessage.getMessage();
            Message message = SerializationUtils.deserialize((byte[])byteMessage, (DeserializerFactory)HeaderTBaseDeserializerFactory.DEFAULT_FACTORY, null);
            if (message == null) {
                throw new IllegalArgumentException("message is null. response message=" + responseMessage);
            }
            TBase tbase = (TBase)message.getData();
            if (!(tbase instanceof TResult)) {
                throw new IllegalArgumentException("invalid message data. response message=" + responseMessage + ", data=" + tbase.getClass());
            }
            final TResult result = (TResult)tbase;
            return new ResultResponse(){

                @Override
                public boolean isSuccess() {
                    return result.isSuccess();
                }

                @Override
                public String getMessage() {
                    return result.getMessage();
                }
            };
        }
        return null;
    }
}

