/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class ASMTryCatch {
    private final MethodNode methodNode;
    private final LabelNode startLabelNode = new LabelNode();
    private final LabelNode endLabelNode = new LabelNode();

    public ASMTryCatch(MethodNode methodNode) {
        this.methodNode = methodNode;
        TryCatchBlockNode tryCatchBlockNode = new TryCatchBlockNode(this.startLabelNode, this.endLabelNode, this.endLabelNode, "java/lang/Throwable");
        if (this.methodNode.tryCatchBlocks == null) {
            this.methodNode.tryCatchBlocks = new ArrayList();
        }
        this.methodNode.tryCatchBlocks.add(tryCatchBlockNode);
    }

    public LabelNode getStartLabelNode() {
        return this.startLabelNode;
    }

    public LabelNode getEndLabelNode() {
        return this.endLabelNode;
    }

    public void sort() {
        if (this.methodNode.tryCatchBlocks == null) {
            return;
        }
        Collections.sort(this.methodNode.tryCatchBlocks, new Comparator<TryCatchBlockNode>(){

            @Override
            public int compare(TryCatchBlockNode o1, TryCatchBlockNode o2) {
                return Integer.compare(this.blockLength(o1), this.blockLength(o2));
            }

            private int blockLength(TryCatchBlockNode block) {
                int startidx = ((ASMTryCatch)ASMTryCatch.this).methodNode.instructions.indexOf((AbstractInsnNode)block.start);
                int endidx = ((ASMTryCatch)ASMTryCatch.this).methodNode.instructions.indexOf((AbstractInsnNode)block.end);
                return endidx - startidx;
            }
        });
        for (int i = 0; i < this.methodNode.tryCatchBlocks.size(); ++i) {
            ((TryCatchBlockNode)this.methodNode.tryCatchBlocks.get(i)).updateIndex(i);
        }
    }
}

