/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import java.io.InputStream;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BootstrapClassLoaderHandler
implements ClassInjector {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final PluginConfig pluginConfig;
    private final InstrumentEngine instrumentEngine;
    private final Object lock = new Object();
    private volatile boolean injectedToRoot = false;

    public BootstrapClassLoaderHandler(PluginConfig pluginConfig, InstrumentEngine instrumentEngine) {
        this.pluginConfig = Objects.requireNonNull(pluginConfig, "pluginConfig");
        this.instrumentEngine = Objects.requireNonNull(instrumentEngine, "instrumentEngine");
    }

    @Override
    public <T> Class<? extends T> injectClass(ClassLoader classLoader, String className) {
        if (classLoader != Object.class.getClassLoader()) {
            throw new IllegalStateException("not BootStrapClassLoader");
        }
        try {
            return this.injectClass0(className);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin class {} with classLoader {}", (Object)className, (Object)classLoader, (Object)e);
            throw new PinpointException("Failed to load plugin class " + className + " with classLoader " + classLoader, (Throwable)e);
        }
    }

    private Class<?> injectClass0(String className) throws IllegalArgumentException, ClassNotFoundException {
        this.appendToBootstrapClassLoaderSearch();
        return Class.forName(className, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToBootstrapClassLoaderSearch() {
        if (this.injectedToRoot) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.injectedToRoot) {
                this.instrumentEngine.appendToBootstrapClassPath(this.pluginConfig.getPluginJarFile());
                this.injectedToRoot = true;
            }
        }
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String internalName) {
        try {
            if (targetClassLoader == null) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                if (classLoader == null) {
                    return null;
                }
                this.appendToBootstrapClassLoaderSearch();
                return classLoader.getResourceAsStream(internalName);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin resource as stream {} with classLoader {}", (Object)internalName, (Object)targetClassLoader, (Object)e);
            return null;
        }
        this.logger.warn("Invalid bootstrap class loader. cl={}", (Object)targetClassLoader);
        return null;
    }
}

