/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.lambda;

import com.navercorp.pinpoint.bootstrap.instrument.lambda.LambdaBytecodeHandler;
import com.navercorp.pinpoint.bootstrap.module.ClassFileTransformModuleAdaptor;
import com.navercorp.pinpoint.bootstrap.module.JavaModuleFactory;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.instrument.lambda.DefaultLambdaBytecodeHandler;
import com.navercorp.pinpoint.profiler.instrument.lambda.LambdaBytecodeLogger;
import com.navercorp.pinpoint.profiler.instrument.transformer.InnerClassLambdaMetafactoryTransformer;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LambdaTransformBootloader {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public void transformLambdaFactory(Instrumentation instrumentation, ClassFileTransformModuleAdaptor classFileTransformer, JavaModuleFactory javaModuleFactory) {
        this.logger.info("LambdaTransformBootloader.transformLambdaFactory");
        this.retransform(instrumentation);
        this.registerLambdaBytecodeHandler(classFileTransformer, javaModuleFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retransform(Instrumentation instrumentation) {
        String lambdaMetaFactoryName = "java.lang.invoke.InnerClassLambdaMetafactory";
        try {
            Class<?> lamdbaFactoryClazz = Class.forName("java.lang.invoke.InnerClassLambdaMetafactory", false, null);
            this.logger.info("retransformClasses:{}", lamdbaFactoryClazz);
            InnerClassLambdaMetafactoryTransformer classFileTransfomrer = new InnerClassLambdaMetafactoryTransformer();
            instrumentation.addTransformer(classFileTransfomrer, true);
            try {
                instrumentation.retransformClasses(lamdbaFactoryClazz);
            }
            finally {
                instrumentation.removeTransformer(classFileTransfomrer);
            }
        }
        catch (Exception e) {
            this.logger.warn("retransform fail class:{}", (Object)"java.lang.invoke.InnerClassLambdaMetafactory", (Object)e);
        }
    }

    private void registerLambdaBytecodeHandler(ClassFileTransformModuleAdaptor classFileTransformer, JavaModuleFactory javaModuleFactory) {
        try {
            this.logger.info("register LambdaBytecodeHandler");
            LambdaBytecodeHandler lambdaBytecodeHandler = this.newLambdaBytecodeHandler(classFileTransformer, javaModuleFactory);
            Class<?> unsafeDelegator = this.getUnsafeDelegator();
            Method register = unsafeDelegator.getMethod("register", LambdaBytecodeHandler.class);
            boolean success = (Boolean)register.invoke(unsafeDelegator, lambdaBytecodeHandler);
            if (success) {
                this.logger.info("LambdaBytecodeHandler registration success");
            } else {
                this.logger.warn("LambdaBytecodeHandler registration fail");
            }
        }
        catch (Exception e) {
            this.logger.error("LambdaBytecodeHandler registration fail Caused by:" + e.getMessage(), (Throwable)e);
        }
    }

    private LambdaBytecodeHandler newLambdaBytecodeHandler(ClassFileTransformModuleAdaptor classFileTransformer, JavaModuleFactory javaModuleFactory) {
        DefaultLambdaBytecodeHandler lambdaBytecodeHandler = new DefaultLambdaBytecodeHandler(classFileTransformer, javaModuleFactory);
        Logger logger = LogManager.getLogger(lambdaBytecodeHandler.getClass());
        if (logger.isDebugEnabled()) {
            return new LambdaBytecodeLogger(lambdaBytecodeHandler);
        }
        return lambdaBytecodeHandler;
    }

    private Class<?> getUnsafeDelegator() throws ClassNotFoundException {
        String delegatorName = this.getDelegatorName();
        return Class.forName(delegatorName, false, null);
    }

    private String getDelegatorName() {
        if (JvmUtils.getVersion().onOrAfter(JvmVersion.JAVA_9)) {
            return JavaAssistUtils.jvmNameToJavaName("com/navercorp/pinpoint/bootstrap/java9/lambda/UnsafeDelegatorJava9");
        }
        return JavaAssistUtils.jvmNameToJavaName("com/navercorp/pinpoint/bootstrap/java8/lambda/UnsafeDelegatorJava8");
    }
}

