/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.navercorp.pinpoint.common.util.BytesUtils;
import com.navercorp.pinpoint.profiler.metadata.Result;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleCache<T> {
    private final AtomicInteger idGen;
    private final ConcurrentMap<T, Result> cache;
    private final IdTransformer idTransformer;

    public SimpleCache(IdTransformer idTransformer) {
        this(idTransformer, 1024, 1);
    }

    public SimpleCache(IdTransformer idTransformer, int cacheSize) {
        this(idTransformer, cacheSize, 1);
    }

    public SimpleCache(IdTransformer idTransformer, int cacheSize, int startValue) {
        this.idGen = new AtomicInteger(startValue);
        this.cache = this.createCache(cacheSize);
        this.idTransformer = Objects.requireNonNull(idTransformer, "idTransformer");
    }

    private ConcurrentMap<T, Result> createCache(int maxCacheSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.concurrencyLevel(64);
        cacheBuilder.initialCapacity(maxCacheSize);
        cacheBuilder.maximumSize((long)maxCacheSize);
        Cache localCache = cacheBuilder.build();
        ConcurrentMap cache = localCache.asMap();
        return cache;
    }

    public Result put(T value) {
        Result find = (Result)this.cache.get(value);
        if (find != null) {
            return find;
        }
        int newId = this.nextId();
        Result result = new Result(false, newId);
        Result before = this.cache.putIfAbsent(value, result);
        if (before != null) {
            return before;
        }
        return new Result(true, newId);
    }

    private int nextId() {
        int nextId = this.idGen.getAndIncrement();
        return this.idTransformer.transform(nextId);
    }

    public static class BypassTransformer
    implements IdTransformer {
        @Override
        public int transform(int id) {
            return id;
        }
    }

    public static class ZigZagTransformer
    implements IdTransformer {
        @Override
        public int transform(int id) {
            return BytesUtils.zigzagToInt((int)id);
        }
    }

    public static interface IdTransformer {
        public int transform(int var1);
    }
}

