/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollectJob
implements Runnable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DataSender<MetricType> dataSender;
    private final String agentId;
    private final long agentStartTimestamp;
    private final AgentStatMetricCollector<AgentStatMetricSnapshot> agentStatCollector;
    private final int numCollectionsPerBatch;
    private int collectCount = 0;
    private long prevCollectionTimestamp = System.currentTimeMillis();
    private List<AgentStatMetricSnapshot> agentStats;

    public CollectJob(DataSender<MetricType> dataSender, String agentId, long agentStartTimestamp, AgentStatMetricCollector<AgentStatMetricSnapshot> agentStatCollector, int numCollectionsPerBatch) {
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.agentId = agentId;
        this.agentStartTimestamp = agentStartTimestamp;
        this.agentStatCollector = agentStatCollector;
        this.numCollectionsPerBatch = numCollectionsPerBatch;
        this.agentStats = new ArrayList<AgentStatMetricSnapshot>(numCollectionsPerBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long currentCollectionTimestamp = System.currentTimeMillis();
        long collectInterval = currentCollectionTimestamp - this.prevCollectionTimestamp;
        try {
            AgentStatMetricSnapshot agentStat = this.agentStatCollector.collect();
            agentStat.setTimestamp(currentCollectionTimestamp);
            agentStat.setCollectInterval(collectInterval);
            this.agentStats.add(agentStat);
            if (++this.collectCount >= this.numCollectionsPerBatch) {
                this.sendAgentStats();
                this.collectCount = 0;
            }
        }
        catch (Exception ex) {
            this.logger.warn("AgentStat collect failed. Caused:{}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            this.prevCollectionTimestamp = currentCollectionTimestamp;
        }
    }

    private void sendAgentStats() {
        AgentStatMetricSnapshotBatch agentStatBatch = new AgentStatMetricSnapshotBatch();
        agentStatBatch.setAgentId(this.agentId);
        agentStatBatch.setStartTimestamp(this.agentStartTimestamp);
        agentStatBatch.setAgentStats(this.agentStats);
        this.agentStats = new ArrayList<AgentStatMetricSnapshot>(this.numCollectionsPerBatch);
        this.logger.trace("collect agentStat:{}", (Object)agentStatBatch);
        this.dataSender.send(agentStatBatch);
    }
}

