/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.gc;

import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorType;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.JvmGcType;
import java.lang.management.GarbageCollectorMXBean;
import java.util.Objects;

public class DefaultGarbageCollectorMetric
implements GarbageCollectorMetric {
    private final GarbageCollectorType garbageCollectorType;
    private final GarbageCollectorMXBean garbageCollectorMXBean;

    public DefaultGarbageCollectorMetric(GarbageCollectorType garbageCollectorType, GarbageCollectorMXBean garbageCollectorMXBean) {
        this.garbageCollectorType = Objects.requireNonNull(garbageCollectorType, "garbageCollectorType");
        this.garbageCollectorMXBean = Objects.requireNonNull(garbageCollectorMXBean, "garbageCollectorMXBean");
    }

    @Override
    public JvmGcType getGcType() {
        return this.garbageCollectorType.jvmGcType();
    }

    @Override
    public GarbageCollectorMetricSnapshot getSnapshot() {
        long gcCount = this.garbageCollectorMXBean.getCollectionCount();
        long gcTime = this.garbageCollectorMXBean.getCollectionTime();
        return new GarbageCollectorMetricSnapshot(gcCount, gcTime);
    }

    public String toString() {
        return (Object)((Object)this.garbageCollectorType) + " garbage collector metric";
    }
}

