/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sampler;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.profiler.sampler.FalseSampler;
import com.navercorp.pinpoint.profiler.sampler.PercentRateSampler;
import com.navercorp.pinpoint.profiler.sampler.SamplerFactory;
import com.navercorp.pinpoint.profiler.sampler.TrueSampler;

public class PercentSamplerFactory
implements SamplerFactory {
    private final long samplingRate;

    public PercentSamplerFactory(long samplingRate) {
        this.samplingRate = samplingRate;
    }

    public PercentSamplerFactory(Config config) {
        this(config.getSamplingRate());
    }

    @Override
    public Sampler createSampler() {
        if (this.samplingRate <= 0L) {
            return FalseSampler.INSTANCE;
        }
        if (this.samplingRate >= 10000L) {
            return TrueSampler.INSTANCE;
        }
        return new PercentRateSampler(this.samplingRate);
    }

    public static Config config(ProfilerConfig profilerConfig) {
        String samplingRateStr = profilerConfig.readString("profiler.sampling.percent.sampling-rate", "100");
        long samplingRate = PercentSamplerFactory.parseSamplingRate(samplingRateStr);
        return new Config(samplingRate);
    }

    static long parseSamplingRate(String samplingRateStr) {
        double samplingRateDouble = Double.parseDouble(samplingRateStr);
        return (long)(samplingRateDouble * 100.0);
    }

    public static class Config {
        private final long samplingRate;

        public Config(long samplingRate) {
            this.samplingRate = samplingRate;
        }

        public long getSamplingRate() {
            return this.samplingRate;
        }

        public String toString() {
            return "Config{samplingRate=" + this.samplingRate + '}';
        }
    }
}

