/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutor;
import com.navercorp.pinpoint.profiler.sender.ByteMessage;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.DefaultAsyncQueueingExecutorListener;
import com.navercorp.pinpoint.profiler.sender.MessageSerializer;
import com.navercorp.pinpoint.profiler.sender.RefreshStrategy;
import com.navercorp.pinpoint.profiler.sender.UdpSocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.DnsSocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UdpDataSender<T>
implements DataSender<T> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final DatagramPacket reusePacket = new DatagramPacket(new byte[1], 1);
    private final DatagramSocket udpSocket;
    private final AsyncQueueingExecutor<T> executor;
    private final UdpSocketAddressProvider socketAddressProvider;
    private final MessageSerializer<T, ByteMessage> messageSerializer;

    public UdpDataSender(String host, int port, String threadName, int queueSize, int timeout, int sendBufferSize, MessageSerializer<T, ByteMessage> messageSerializer) {
        Objects.requireNonNull(host, "host");
        if (!HostAndPort.isValidPort((int)port)) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        Objects.requireNonNull(host, "host");
        Assert.isTrue((queueSize > 0 ? 1 : 0) != 0, (String)"queueSize");
        Assert.isTrue((timeout > 0 ? 1 : 0) != 0, (String)"timeout");
        Assert.isTrue((sendBufferSize > 0 ? 1 : 0) != 0, (String)"sendBufferSize");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "messageSerializer");
        DnsSocketAddressProvider socketAddressProvider = new DnsSocketAddressProvider(host, port);
        this.socketAddressProvider = new RefreshStrategy((SocketAddressProvider)socketAddressProvider);
        InetSocketAddress currentAddress = this.socketAddressProvider.resolve();
        this.logger.info("UdpDataSender initialized. host={}", (Object)currentAddress);
        this.udpSocket = this.createSocket(timeout, sendBufferSize);
        this.executor = this.createAsyncQueueingExecutor(queueSize, threadName);
    }

    @Override
    public boolean send(T data) {
        return this.executor.execute(data);
    }

    private AsyncQueueingExecutor<T> createAsyncQueueingExecutor(int queueSize, String executorName) {
        DefaultAsyncQueueingExecutorListener listener = new DefaultAsyncQueueingExecutorListener<T>(){

            @Override
            public void execute(T message) {
                UdpDataSender.this.sendPacket(message);
            }
        };
        AsyncQueueingExecutor executor = new AsyncQueueingExecutor(queueSize, executorName, listener);
        return executor;
    }

    @Override
    public void stop() {
        this.executor.stop();
    }

    private DatagramSocket createSocket(int timeout, int sendBufferSize) {
        try {
            int checkSendBufferSize;
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(timeout);
            datagramSocket.setSendBufferSize(sendBufferSize);
            if (this.logger.isInfoEnabled() && sendBufferSize != (checkSendBufferSize = datagramSocket.getSendBufferSize())) {
                this.logger.info("DatagramSocket.setSendBufferSize() error. {}!={}", (Object)sendBufferSize, (Object)checkSendBufferSize);
            }
            return datagramSocket;
        }
        catch (SocketException e) {
            throw new IllegalStateException("DatagramSocket create fail. Cause" + e.getMessage(), e);
        }
    }

    private void sendPacket(T message) {
        InetSocketAddress inetSocketAddress = this.socketAddressProvider.resolve();
        if (inetSocketAddress.getAddress() == null) {
            this.logger.info("dns lookup fail host:{}", (Object)inetSocketAddress);
            return;
        }
        ByteMessage byteMessage = this.messageSerializer.serializer(message);
        if (byteMessage == null) {
            this.logger.warn("sendPacket fail. message:{}", message != null ? message.getClass() : null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("unknown message:{}", message);
            }
            return;
        }
        DatagramPacket packet = this.preparePacket(inetSocketAddress, byteMessage);
        try {
            this.udpSocket.send(packet);
            if (this.isDebug) {
                this.logger.debug("Data sent. size:{}, {}", (Object)byteMessage.getLength(), message);
            }
        }
        catch (PortUnreachableException pe) {
            this.socketAddressProvider.handlePortUnreachable();
            this.logger.info("packet send error. size:{}, {}", (Object)byteMessage.getLength(), message, (Object)pe);
        }
        catch (IOException e) {
            this.logger.info("packet send error. size:{}, {}", (Object)byteMessage.getLength(), message, (Object)e);
        }
    }

    private DatagramPacket preparePacket(InetSocketAddress targetAddress, ByteMessage byteMessage) {
        this.reusePacket.setAddress(targetAddress.getAddress());
        this.reusePacket.setPort(targetAddress.getPort());
        this.reusePacket.setData(byteMessage.getMessage(), 0, byteMessage.getLength());
        return this.reusePacket;
    }
}

