/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.SocketIdClientInterceptor;
import com.navercorp.pinpoint.grpc.trace.AgentGrpc;
import com.navercorp.pinpoint.grpc.trace.PAgentInfo;
import com.navercorp.pinpoint.grpc.trace.PResult;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.grpc.CommandServiceStubFactory;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcCommandService;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.GrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.PingStreamContext;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import com.navercorp.pinpoint.rpc.DefaultFuture;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.PinpointClientReconnectEventListener;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.netty.buffer.ChannelBuffers;

public class AgentGrpcDataSender<T>
extends GrpcDataSender<T>
implements EnhancedDataSender<T> {
    private final AgentGrpc.AgentStub agentInfoStub;
    private final AgentGrpc.AgentStub agentPingStub;
    private final GrpcCommandService grpcCommandService;
    private final ReconnectExecutor reconnectExecutor;
    private volatile PingStreamContext pingStreamContext;
    private final Reconnector reconnector;

    public AgentGrpcDataSender(String host, int port, int executorQueueSize, MessageConverter<T, GeneratedMessageV3> messageConverter, ReconnectExecutor reconnectExecutor, final ScheduledExecutorService retransmissionExecutor, ChannelFactory channelFactory, ProfilerCommandServiceLocator profilerCommandServiceLocator) {
        super(host, port, executorQueueSize, messageConverter, channelFactory);
        this.agentInfoStub = AgentGrpc.newStub((Channel)this.managedChannel);
        this.agentPingStub = this.newAgentPingStub();
        this.reconnectExecutor = reconnectExecutor;
        CommandServiceStubFactory commandServiceStubFactory = new CommandServiceStubFactory(this.managedChannel);
        this.grpcCommandService = new GrpcCommandService(commandServiceStubFactory, reconnectExecutor, profilerCommandServiceLocator);
        Runnable reconnectJob = new Runnable(){

            @Override
            public void run() {
                AgentGrpcDataSender.this.pingStreamContext = AgentGrpcDataSender.this.newPingStream(AgentGrpcDataSender.this.agentPingStub, retransmissionExecutor);
            }
        };
        this.reconnector = reconnectExecutor.newReconnector(reconnectJob);
        reconnectJob.run();
    }

    private AgentGrpc.AgentStub newAgentPingStub() {
        AgentGrpc.AgentStub agentStub = AgentGrpc.newStub((Channel)this.managedChannel);
        return (AgentGrpc.AgentStub)agentStub.withInterceptors(new ClientInterceptor[]{new SocketIdClientInterceptor()});
    }

    private PingStreamContext newPingStream(AgentGrpc.AgentStub agentStub, ScheduledExecutorService reconnectScheduler) {
        PingStreamContext pingStreamContext = new PingStreamContext(agentStub, this.reconnector, reconnectScheduler);
        this.logger.info("newPingStream:{}", (Object)pingStreamContext);
        return pingStreamContext;
    }

    @Override
    public boolean request(T data) {
        throw new UnsupportedOperationException("unsupported operation request(data)");
    }

    @Override
    public boolean request(T data, int retryCount) {
        throw new UnsupportedOperationException("unsupported operation request(data, retryCount)");
    }

    @Override
    public boolean request(T data, FutureListener<ResponseMessage> listener) {
        GeneratedMessageV3 message = (GeneratedMessageV3)this.messageConverter.toMessage(data);
        if (!(message instanceof PAgentInfo)) {
            throw new IllegalArgumentException("unsupported message " + data);
        }
        PAgentInfo pAgentInfo = (PAgentInfo)message;
        this.agentInfoStub.requestAgentInfo(pAgentInfo, (StreamObserver)new FutureListenerStreamObserver(listener));
        return true;
    }

    @Override
    public boolean send(Object data) {
        throw new UnsupportedOperationException("unsupported operation send(data)");
    }

    @Override
    public void stop() {
        GrpcCommandService grpcCommandService;
        PingStreamContext pingStreamContext;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.logger.info("Stop {}, channel={}", (Object)this.name, (Object)this.managedChannel);
        ReconnectExecutor reconnectExecutor = this.reconnectExecutor;
        if (reconnectExecutor != null) {
            reconnectExecutor.close();
        }
        if ((pingStreamContext = this.pingStreamContext) != null) {
            pingStreamContext.close();
        }
        if ((grpcCommandService = this.grpcCommandService) != null) {
            grpcCommandService.stop();
        }
        this.release();
    }

    @Override
    public boolean addReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        throw new UnsupportedOperationException("unsupported operation addReconnectEventListener(eventListener)");
    }

    @Override
    public boolean removeReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        throw new UnsupportedOperationException("unsupported operation removeReconnectEventListener(eventListener)");
    }

    static {
        ChannelBuffers.buffer((int)2);
    }

    private static class FutureListenerStreamObserver
    implements StreamObserver<PResult> {
        private final FutureListener<ResponseMessage> listener;

        private FutureListenerStreamObserver(FutureListener<ResponseMessage> listener) {
            this.listener = listener;
        }

        public void onNext(PResult result) {
            DefaultFuture future = new DefaultFuture();
            ResponseMessage responseMessage = new ResponseMessage();
            responseMessage.setMessage(result.toByteArray());
            future.setResult((Object)responseMessage);
            future.setListener(this.listener);
        }

        public void onError(Throwable throwable) {
            DefaultFuture future = new DefaultFuture();
            future.setFailure(throwable);
            future.setListener(this.listener);
        }

        public void onCompleted() {
        }
    }
}

