/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectJob;
import io.grpc.internal.ExponentialBackoffPolicy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ExponentialBackoffReconnectJob
implements ReconnectJob {
    private final long maxBackOffNanos;
    private volatile ExponentialBackoffPolicy exponentialBackoffPolicy = new ExponentialBackoffPolicy();
    private final Runnable runnable;

    public ExponentialBackoffReconnectJob(Runnable runnable) {
        this(runnable, TimeUnit.SECONDS.toNanos(30L));
    }

    public ExponentialBackoffReconnectJob(Runnable runnable, long maxBackOffNanos) {
        this.runnable = Objects.requireNonNull(runnable, "runnable");
        Assert.isTrue((maxBackOffNanos > 0L ? 1 : 0) != 0, (String)"maxBackOffNanos > 0");
        this.maxBackOffNanos = this.getMaxBackOffNanos(maxBackOffNanos);
    }

    private long getMaxBackOffNanos(long maxBackOffNanos) {
        if (TimeUnit.SECONDS.toNanos(3L) > maxBackOffNanos) {
            return TimeUnit.SECONDS.toNanos(3L);
        }
        return maxBackOffNanos;
    }

    @Override
    public final void resetBackoffNanos() {
        this.exponentialBackoffPolicy = new ExponentialBackoffPolicy();
    }

    @Override
    public long nextBackoffNanos() {
        return Math.min(this.exponentialBackoffPolicy.nextBackoffNanos(), this.maxBackOffNanos);
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    public String toString() {
        return "ExponentialBackoffReconnectJob{maxBackOffNanos=" + this.maxBackOffNanos + ", exponentialBackoffPolicy=" + this.exponentialBackoffPolicy + ", runnable=" + this.runnable + '}';
    }
}

