/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import java.lang.annotation.Annotation;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Class<?> getWrapperOf(Class<?> primitive) {
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException("Unexpected argument: " + primitive);
    }

    public static String[] toClassNames(Class<?> ... classes) {
        int length = classes.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = classes[i].getName();
        }
        return result;
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> type) {
        for (Annotation a : annotations) {
            if (a.annotationType() != type) continue;
            return (T)((Annotation)type.cast(a));
        }
        return null;
    }
}

