/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.admin;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.admin.AbstractAdmin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.storage.standalone.broker.MessageQueue;
import org.apache.eventmesh.storage.standalone.broker.StandaloneBroker;
import org.apache.eventmesh.storage.standalone.broker.model.TopicMetadata;

public class StandaloneAdmin
extends AbstractAdmin {
    private final StandaloneBroker standaloneBroker = StandaloneBroker.getInstance();

    public StandaloneAdmin() {
        super(new AtomicBoolean(false));
    }

    public List<TopicProperties> getTopic() throws Exception {
        ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer = this.standaloneBroker.getMessageContainer();
        ArrayList<TopicProperties> topicList = new ArrayList<TopicProperties>();
        ((ConcurrentHashMap.KeySetView)messageContainer.keySet()).forEach(topicMetadata -> {
            MessageQueue messageQueue = (MessageQueue)messageContainer.get(topicMetadata);
            int messageCount = messageQueue.getPutIndex() - messageQueue.getTakeIndex();
            topicList.add(new TopicProperties(topicMetadata.getTopicName(), (long)messageCount));
        });
        topicList.sort(Comparator.comparing(t -> t.name));
        return topicList;
    }

    public void createTopic(String topicName) {
        this.standaloneBroker.createTopicIfAbsent(topicName);
    }

    public void deleteTopic(String topicName) {
        this.standaloneBroker.deleteTopicIfExist(topicName);
    }

    public List<CloudEvent> getEvent(String topicName, int offset, int length) throws Exception {
        long messageOffset;
        CloudEvent event;
        if (!this.standaloneBroker.checkTopicExist(topicName)) {
            throw new Exception("The topic name doesn't exist in the message queue");
        }
        ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer = this.standaloneBroker.getMessageContainer();
        long topicOffset = messageContainer.get(new TopicMetadata(topicName)).getTakeIndex();
        ArrayList<CloudEvent> messageList = new ArrayList<CloudEvent>();
        for (int index = 0; index < length && (event = this.standaloneBroker.getMessage(topicName, messageOffset = topicOffset + (long)offset + (long)index)) != null; ++index) {
            messageList.add(event);
        }
        return messageList;
    }

    public void publish(CloudEvent cloudEvent) throws Exception {
        this.standaloneBroker.putMessage(cloudEvent.getSubject(), cloudEvent);
    }
}

