/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.PublishProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPublishBatchCloudEventProcessor
implements PublishProcessor<CloudEventBatch, CloudEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPublishBatchCloudEventProcessor.class);
    private static final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    protected final EventMeshGrpcServer eventMeshGrpcServer;
    protected final Acl acl;

    public AbstractPublishBatchCloudEventProcessor(EventMeshGrpcServer eventMeshGrpcServer, Acl acl) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.acl = acl;
    }

    @Override
    public void process(CloudEventBatch cloudEvent, EventEmitter<CloudEvent> emitter) throws Exception {
        if (!this.eventMeshGrpcServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            log.error("Send message speed over limit.");
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_SEND_MESSAGE_SPEED_OVER_LIMIT_ERR, emitter);
            return;
        }
        StatusCode cloudEventCheck = this.cloudEventBatchCheck(cloudEvent);
        if (cloudEventCheck != StatusCode.SUCCESS) {
            ServiceUtils.sendResponseCompleted(cloudEventCheck, emitter);
            return;
        }
        StatusCode aclCheck = this.aclCheck(cloudEvent.getEvents(0));
        if (aclCheck != StatusCode.SUCCESS) {
            ServiceUtils.sendResponseCompleted(aclCheck, emitter);
            return;
        }
        this.handleCloudEvent(cloudEvent, emitter);
    }

    public StatusCode cloudEventBatchCheck(CloudEventBatch cloudEventBatch) {
        if (!ServiceUtils.validateCloudEventBatchAttributes(cloudEventBatch)) {
            return StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR;
        }
        if (!ServiceUtils.validateCloudEventBatchData(cloudEventBatch)) {
            return StatusCode.EVENTMESH_PROTOCOL_BODY_ERR;
        }
        return StatusCode.SUCCESS;
    }

    public StatusCode aclCheck(CloudEvent cloudEvent) {
        try {
            if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().isEventMeshServerSecurityEnable()) {
                String remoteAdd = EventMeshCloudEventUtils.getIp((CloudEvent)cloudEvent);
                String user = EventMeshCloudEventUtils.getUserName((CloudEvent)cloudEvent);
                String pass = EventMeshCloudEventUtils.getPassword((CloudEvent)cloudEvent);
                String subsystem = EventMeshCloudEventUtils.getSys((CloudEvent)cloudEvent);
                String topic = EventMeshCloudEventUtils.getSubject((CloudEvent)cloudEvent);
                this.acl.doAclCheckInHttpSend(remoteAdd, user, pass, subsystem, topic, RequestCode.MSG_SEND_ASYNC.getRequestCode());
            }
        }
        catch (AclException e) {
            aclLogger.warn("Client has no permission,AbstructPublishCloudEventProcessor send failed", (Throwable)e);
            return StatusCode.EVENTMESH_ACL_ERR;
        }
        return StatusCode.SUCCESS;
    }

    abstract void handleCloudEvent(CloudEventBatch var1, EventEmitter<CloudEvent> var2) throws Exception;
}

