/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.redis.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Arrays;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.storage.redis.cloudevent.CloudEventCodec;
import org.apache.eventmesh.storage.redis.config.RedisProperties;
import org.redisson.Redisson;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;

public final class RedissonClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Redisson INSTANCE;

    public static Redisson create() {
        ConfigService configService = ConfigService.getInstance();
        RedisProperties properties = (RedisProperties)configService.buildConfigInstance(RedisProperties.class);
        return RedissonClient.create(properties);
    }

    private static Redisson create(RedisProperties properties) {
        RedisProperties.ServerType serverType;
        try {
            serverType = properties.getServerType();
        }
        catch (IllegalArgumentException ie) {
            String message = "Invalid Redis server type: " + (Object)((Object)properties.getServerType()) + ", supported values are: " + Arrays.toString((Object[])RedisProperties.ServerType.values());
            throw new StorageRuntimeException(message, (Throwable)ie);
        }
        String serverAddress = properties.getServerAddress();
        String serverPassword = properties.getServerPassword();
        String masterName = properties.getServerMasterName();
        Config config = (Config)OBJECT_MAPPER.convertValue((Object)properties.getRedissonProperties(), Config.class);
        if (config == null) {
            config = new Config();
        }
        config.setCodec((Codec)CloudEventCodec.getInstance());
        switch (serverType) {
            case SINGLE: {
                config.useSingleServer().setAddress(serverAddress).setPassword(serverPassword);
                break;
            }
            case CLUSTER: {
                config.useClusterServers().addNodeAddress(serverAddress.split(",")).setPassword(serverPassword);
                break;
            }
            case SENTINEL: {
                config.useSentinelServers().setMasterName(masterName).addSentinelAddress(new String[]{serverAddress}).setPassword(serverPassword);
                break;
            }
            default: {
                String message = "Invalid Redis server type: " + (Object)((Object)properties.getServerType()) + ", supported values are: " + Arrays.toString((Object[])RedisProperties.ServerType.values());
                throw new StorageRuntimeException(message);
            }
        }
        return (Redisson)Redisson.create((Config)config);
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        INSTANCE = RedissonClient.create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                INSTANCE.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }
}

