/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.service;

import io.cloudevents.SpecVersion;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.ConsumerServiceGrpc;
import org.apache.eventmesh.connector.openfunction.client.CallbackServiceGrpc;
import org.apache.eventmesh.connector.openfunction.config.OpenFunctionServerConfig;
import org.apache.eventmesh.connector.openfunction.sink.connector.OpenFunctionSinkConnector;
import org.apache.eventmesh.openconnect.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerService
extends ConsumerServiceGrpc.ConsumerServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(ConsumerService.class);
    public OpenFunctionSinkConnector openFunctionSinkConnector;
    public BlockingQueue<ConnectRecord> queue;
    public OpenFunctionServerConfig config;
    private final transient ManagedChannel channel = ManagedChannelBuilder.forAddress((String)"127.0.0.1", (int)10115).usePlaintext().build();
    private CallbackServiceGrpc.CallbackServiceBlockingStub publisherClient = CallbackServiceGrpc.newBlockingStub((Channel)this.channel);
    private final ExecutorService handleService = Executors.newSingleThreadExecutor();

    public ConsumerService(OpenFunctionSinkConnector openFunctionSinkConnector, OpenFunctionServerConfig serverConfig) {
        this.openFunctionSinkConnector = openFunctionSinkConnector;
        this.queue = openFunctionSinkConnector.queue();
        this.config = serverConfig;
        this.handleService.execute(this::startHandleConsumeEvents);
    }

    private void startHandleConsumeEvents() {
        while (this.openFunctionSinkConnector.isRunning()) {
            ConnectRecord connectRecord = (ConnectRecord)this.queue.poll();
            if (connectRecord == null) continue;
            CloudEvent cloudEvent = this.publisherClient.onTopicEvent(this.convertRecordToEvent(connectRecord));
        }
    }

    private CloudEvent convertRecordToEvent(ConnectRecord connectRecord) {
        CloudEvent.Builder cloudEventBuilder = CloudEvent.newBuilder();
        cloudEventBuilder.setId(connectRecord.getExtension("id"));
        cloudEventBuilder.setSource(connectRecord.getExtension("source"));
        cloudEventBuilder.setSpecVersion(SpecVersion.V1.toString());
        cloudEventBuilder.setType(connectRecord.getExtension("type"));
        cloudEventBuilder.setTextData(new String((byte[])connectRecord.getData()));
        for (String extensionKey : connectRecord.getExtensions().keySet()) {
            if (StringUtils.equalsAny((CharSequence)extensionKey, (CharSequence[])new CharSequence[]{"id", "source", "type"})) continue;
            cloudEventBuilder.putAttributes(extensionKey, CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(connectRecord.getExtension(extensionKey)).build());
        }
        return cloudEventBuilder.build();
    }
}

