/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigFiled;
import org.apache.eventmesh.common.utils.IPUtils;
import org.assertj.core.util.Strings;

@Config(prefix="eventMesh")
public class CommonConfiguration {
    @ConfigFiled(field="sysid", beNumber=true, notEmpty=true)
    private String sysID = "5477";
    @ConfigFiled(field="server.env", notEmpty=true)
    private String eventMeshEnv = "P";
    @ConfigFiled(field="server.idc", notEmpty=true)
    private String eventMeshIDC = "FT";
    @ConfigFiled(field="server.name", notEmpty=true)
    private String eventMeshName = "";
    @ConfigFiled(field="server.cluster", notEmpty=true)
    private String eventMeshCluster = "LS";
    @ConfigFiled(field="server.hostIp", reload=true)
    private String eventMeshServerIp = null;
    @ConfigFiled(field="registry.plugin.server-addr", notEmpty=true)
    private String namesrvAddr = "";
    @ConfigFiled(field="trace.plugin", notEmpty=true)
    private String eventMeshTracePluginType;
    @ConfigFiled(field="metrics.plugin", notEmpty=true)
    private List<String> eventMeshMetricsPluginType;
    @ConfigFiled(field="registry.plugin.type", notEmpty=true)
    private String eventMeshRegistryPluginType = "namesrv";
    @ConfigFiled(field="security.plugin.type", notEmpty=true)
    private String eventMeshSecurityPluginType = "security";
    @ConfigFiled(field="connector.plugin.type", notEmpty=true)
    private String eventMeshConnectorPluginType = "rocketmq";
    @ConfigFiled(field="storage.plugin.type", notEmpty=true)
    private String eventMeshStoragePluginType = "rocketmq";
    @ConfigFiled(field="security.validation.type.token", notEmpty=true)
    private boolean eventMeshSecurityValidateTypeToken = false;
    @ConfigFiled(field="registry.plugin.username")
    private String eventMeshRegistryPluginUsername = "";
    @ConfigFiled(field="registry.plugin.password")
    private String eventMeshRegistryPluginPassword = "";
    @ConfigFiled(field="server.registry.registerIntervalInMills")
    private Integer eventMeshRegisterIntervalInMills = 10000;
    @ConfigFiled(field="server.registry.fetchRegistryAddrIntervalInMills")
    private Integer eventMeshFetchRegistryAddrInterval = 10000;
    @ConfigFiled(field="server.trace.enabled")
    private boolean eventMeshServerTraceEnable = false;
    @ConfigFiled(field="server.security.enabled")
    private boolean eventMeshServerSecurityEnable = false;
    @ConfigFiled(field="server.registry.enabled")
    private boolean eventMeshServerRegistryEnable = false;
    @ConfigFiled(field="security.publickey")
    private String eventMeshSecurityPublickey = "";
    @ConfigFiled(field="server.provide.protocols", reload=true)
    private List<String> eventMeshProvideServerProtocols;
    @ConfigFiled(reload=true)
    private String eventMeshWebhookOrigin;
    @ConfigFiled(reload=true)
    private String meshGroup;

    public void reload() {
        this.eventMeshWebhookOrigin = "eventmesh." + this.eventMeshIDC;
        if (Strings.isNullOrEmpty((String)this.eventMeshServerIp)) {
            this.eventMeshServerIp = IPUtils.getLocalAddress();
        }
        if (CollectionUtils.isEmpty(this.eventMeshProvideServerProtocols)) {
            this.eventMeshProvideServerProtocols = Collections.singletonList("HTTP");
        }
        this.meshGroup = String.join((CharSequence)"-", this.eventMeshEnv, this.eventMeshCluster, this.sysID);
    }

    public String getSysID() {
        return this.sysID;
    }

    public String getEventMeshEnv() {
        return this.eventMeshEnv;
    }

    public String getEventMeshIDC() {
        return this.eventMeshIDC;
    }

    public String getEventMeshName() {
        return this.eventMeshName;
    }

    public String getEventMeshCluster() {
        return this.eventMeshCluster;
    }

    public String getEventMeshServerIp() {
        return this.eventMeshServerIp;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public String getEventMeshTracePluginType() {
        return this.eventMeshTracePluginType;
    }

    public List<String> getEventMeshMetricsPluginType() {
        return this.eventMeshMetricsPluginType;
    }

    public String getEventMeshRegistryPluginType() {
        return this.eventMeshRegistryPluginType;
    }

    public String getEventMeshSecurityPluginType() {
        return this.eventMeshSecurityPluginType;
    }

    public String getEventMeshConnectorPluginType() {
        return this.eventMeshConnectorPluginType;
    }

    public String getEventMeshStoragePluginType() {
        return this.eventMeshStoragePluginType;
    }

    public boolean isEventMeshSecurityValidateTypeToken() {
        return this.eventMeshSecurityValidateTypeToken;
    }

    public String getEventMeshRegistryPluginUsername() {
        return this.eventMeshRegistryPluginUsername;
    }

    public String getEventMeshRegistryPluginPassword() {
        return this.eventMeshRegistryPluginPassword;
    }

    public Integer getEventMeshRegisterIntervalInMills() {
        return this.eventMeshRegisterIntervalInMills;
    }

    public Integer getEventMeshFetchRegistryAddrInterval() {
        return this.eventMeshFetchRegistryAddrInterval;
    }

    public boolean isEventMeshServerTraceEnable() {
        return this.eventMeshServerTraceEnable;
    }

    public boolean isEventMeshServerSecurityEnable() {
        return this.eventMeshServerSecurityEnable;
    }

    public boolean isEventMeshServerRegistryEnable() {
        return this.eventMeshServerRegistryEnable;
    }

    public String getEventMeshSecurityPublickey() {
        return this.eventMeshSecurityPublickey;
    }

    public List<String> getEventMeshProvideServerProtocols() {
        return this.eventMeshProvideServerProtocols;
    }

    public String getEventMeshWebhookOrigin() {
        return this.eventMeshWebhookOrigin;
    }

    public String getMeshGroup() {
        return this.meshGroup;
    }

    public void setSysID(String sysID) {
        this.sysID = sysID;
    }

    public void setEventMeshEnv(String eventMeshEnv) {
        this.eventMeshEnv = eventMeshEnv;
    }

    public void setEventMeshIDC(String eventMeshIDC) {
        this.eventMeshIDC = eventMeshIDC;
    }

    public void setEventMeshName(String eventMeshName) {
        this.eventMeshName = eventMeshName;
    }

    public void setEventMeshCluster(String eventMeshCluster) {
        this.eventMeshCluster = eventMeshCluster;
    }

    public void setEventMeshServerIp(String eventMeshServerIp) {
        this.eventMeshServerIp = eventMeshServerIp;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public void setEventMeshTracePluginType(String eventMeshTracePluginType) {
        this.eventMeshTracePluginType = eventMeshTracePluginType;
    }

    public void setEventMeshMetricsPluginType(List<String> eventMeshMetricsPluginType) {
        this.eventMeshMetricsPluginType = eventMeshMetricsPluginType;
    }

    public void setEventMeshRegistryPluginType(String eventMeshRegistryPluginType) {
        this.eventMeshRegistryPluginType = eventMeshRegistryPluginType;
    }

    public void setEventMeshSecurityPluginType(String eventMeshSecurityPluginType) {
        this.eventMeshSecurityPluginType = eventMeshSecurityPluginType;
    }

    public void setEventMeshConnectorPluginType(String eventMeshConnectorPluginType) {
        this.eventMeshConnectorPluginType = eventMeshConnectorPluginType;
    }

    public void setEventMeshStoragePluginType(String eventMeshStoragePluginType) {
        this.eventMeshStoragePluginType = eventMeshStoragePluginType;
    }

    public void setEventMeshSecurityValidateTypeToken(boolean eventMeshSecurityValidateTypeToken) {
        this.eventMeshSecurityValidateTypeToken = eventMeshSecurityValidateTypeToken;
    }

    public void setEventMeshRegistryPluginUsername(String eventMeshRegistryPluginUsername) {
        this.eventMeshRegistryPluginUsername = eventMeshRegistryPluginUsername;
    }

    public void setEventMeshRegistryPluginPassword(String eventMeshRegistryPluginPassword) {
        this.eventMeshRegistryPluginPassword = eventMeshRegistryPluginPassword;
    }

    public void setEventMeshRegisterIntervalInMills(Integer eventMeshRegisterIntervalInMills) {
        this.eventMeshRegisterIntervalInMills = eventMeshRegisterIntervalInMills;
    }

    public void setEventMeshFetchRegistryAddrInterval(Integer eventMeshFetchRegistryAddrInterval) {
        this.eventMeshFetchRegistryAddrInterval = eventMeshFetchRegistryAddrInterval;
    }

    public void setEventMeshServerTraceEnable(boolean eventMeshServerTraceEnable) {
        this.eventMeshServerTraceEnable = eventMeshServerTraceEnable;
    }

    public void setEventMeshServerSecurityEnable(boolean eventMeshServerSecurityEnable) {
        this.eventMeshServerSecurityEnable = eventMeshServerSecurityEnable;
    }

    public void setEventMeshServerRegistryEnable(boolean eventMeshServerRegistryEnable) {
        this.eventMeshServerRegistryEnable = eventMeshServerRegistryEnable;
    }

    public void setEventMeshSecurityPublickey(String eventMeshSecurityPublickey) {
        this.eventMeshSecurityPublickey = eventMeshSecurityPublickey;
    }

    public void setEventMeshProvideServerProtocols(List<String> eventMeshProvideServerProtocols) {
        this.eventMeshProvideServerProtocols = eventMeshProvideServerProtocols;
    }

    public void setEventMeshWebhookOrigin(String eventMeshWebhookOrigin) {
        this.eventMeshWebhookOrigin = eventMeshWebhookOrigin;
    }

    public void setMeshGroup(String meshGroup) {
        this.meshGroup = meshGroup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonConfiguration)) {
            return false;
        }
        CommonConfiguration other = (CommonConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEventMeshSecurityValidateTypeToken() != other.isEventMeshSecurityValidateTypeToken()) {
            return false;
        }
        if (this.isEventMeshServerTraceEnable() != other.isEventMeshServerTraceEnable()) {
            return false;
        }
        if (this.isEventMeshServerSecurityEnable() != other.isEventMeshServerSecurityEnable()) {
            return false;
        }
        if (this.isEventMeshServerRegistryEnable() != other.isEventMeshServerRegistryEnable()) {
            return false;
        }
        Integer this$eventMeshRegisterIntervalInMills = this.getEventMeshRegisterIntervalInMills();
        Integer other$eventMeshRegisterIntervalInMills = other.getEventMeshRegisterIntervalInMills();
        if (this$eventMeshRegisterIntervalInMills == null ? other$eventMeshRegisterIntervalInMills != null : !((Object)this$eventMeshRegisterIntervalInMills).equals(other$eventMeshRegisterIntervalInMills)) {
            return false;
        }
        Integer this$eventMeshFetchRegistryAddrInterval = this.getEventMeshFetchRegistryAddrInterval();
        Integer other$eventMeshFetchRegistryAddrInterval = other.getEventMeshFetchRegistryAddrInterval();
        if (this$eventMeshFetchRegistryAddrInterval == null ? other$eventMeshFetchRegistryAddrInterval != null : !((Object)this$eventMeshFetchRegistryAddrInterval).equals(other$eventMeshFetchRegistryAddrInterval)) {
            return false;
        }
        String this$sysID = this.getSysID();
        String other$sysID = other.getSysID();
        if (this$sysID == null ? other$sysID != null : !this$sysID.equals(other$sysID)) {
            return false;
        }
        String this$eventMeshEnv = this.getEventMeshEnv();
        String other$eventMeshEnv = other.getEventMeshEnv();
        if (this$eventMeshEnv == null ? other$eventMeshEnv != null : !this$eventMeshEnv.equals(other$eventMeshEnv)) {
            return false;
        }
        String this$eventMeshIDC = this.getEventMeshIDC();
        String other$eventMeshIDC = other.getEventMeshIDC();
        if (this$eventMeshIDC == null ? other$eventMeshIDC != null : !this$eventMeshIDC.equals(other$eventMeshIDC)) {
            return false;
        }
        String this$eventMeshName = this.getEventMeshName();
        String other$eventMeshName = other.getEventMeshName();
        if (this$eventMeshName == null ? other$eventMeshName != null : !this$eventMeshName.equals(other$eventMeshName)) {
            return false;
        }
        String this$eventMeshCluster = this.getEventMeshCluster();
        String other$eventMeshCluster = other.getEventMeshCluster();
        if (this$eventMeshCluster == null ? other$eventMeshCluster != null : !this$eventMeshCluster.equals(other$eventMeshCluster)) {
            return false;
        }
        String this$eventMeshServerIp = this.getEventMeshServerIp();
        String other$eventMeshServerIp = other.getEventMeshServerIp();
        if (this$eventMeshServerIp == null ? other$eventMeshServerIp != null : !this$eventMeshServerIp.equals(other$eventMeshServerIp)) {
            return false;
        }
        String this$namesrvAddr = this.getNamesrvAddr();
        String other$namesrvAddr = other.getNamesrvAddr();
        if (this$namesrvAddr == null ? other$namesrvAddr != null : !this$namesrvAddr.equals(other$namesrvAddr)) {
            return false;
        }
        String this$eventMeshTracePluginType = this.getEventMeshTracePluginType();
        String other$eventMeshTracePluginType = other.getEventMeshTracePluginType();
        if (this$eventMeshTracePluginType == null ? other$eventMeshTracePluginType != null : !this$eventMeshTracePluginType.equals(other$eventMeshTracePluginType)) {
            return false;
        }
        List<String> this$eventMeshMetricsPluginType = this.getEventMeshMetricsPluginType();
        List<String> other$eventMeshMetricsPluginType = other.getEventMeshMetricsPluginType();
        if (this$eventMeshMetricsPluginType == null ? other$eventMeshMetricsPluginType != null : !((Object)this$eventMeshMetricsPluginType).equals(other$eventMeshMetricsPluginType)) {
            return false;
        }
        String this$eventMeshRegistryPluginType = this.getEventMeshRegistryPluginType();
        String other$eventMeshRegistryPluginType = other.getEventMeshRegistryPluginType();
        if (this$eventMeshRegistryPluginType == null ? other$eventMeshRegistryPluginType != null : !this$eventMeshRegistryPluginType.equals(other$eventMeshRegistryPluginType)) {
            return false;
        }
        String this$eventMeshSecurityPluginType = this.getEventMeshSecurityPluginType();
        String other$eventMeshSecurityPluginType = other.getEventMeshSecurityPluginType();
        if (this$eventMeshSecurityPluginType == null ? other$eventMeshSecurityPluginType != null : !this$eventMeshSecurityPluginType.equals(other$eventMeshSecurityPluginType)) {
            return false;
        }
        String this$eventMeshConnectorPluginType = this.getEventMeshConnectorPluginType();
        String other$eventMeshConnectorPluginType = other.getEventMeshConnectorPluginType();
        if (this$eventMeshConnectorPluginType == null ? other$eventMeshConnectorPluginType != null : !this$eventMeshConnectorPluginType.equals(other$eventMeshConnectorPluginType)) {
            return false;
        }
        String this$eventMeshStoragePluginType = this.getEventMeshStoragePluginType();
        String other$eventMeshStoragePluginType = other.getEventMeshStoragePluginType();
        if (this$eventMeshStoragePluginType == null ? other$eventMeshStoragePluginType != null : !this$eventMeshStoragePluginType.equals(other$eventMeshStoragePluginType)) {
            return false;
        }
        String this$eventMeshRegistryPluginUsername = this.getEventMeshRegistryPluginUsername();
        String other$eventMeshRegistryPluginUsername = other.getEventMeshRegistryPluginUsername();
        if (this$eventMeshRegistryPluginUsername == null ? other$eventMeshRegistryPluginUsername != null : !this$eventMeshRegistryPluginUsername.equals(other$eventMeshRegistryPluginUsername)) {
            return false;
        }
        String this$eventMeshRegistryPluginPassword = this.getEventMeshRegistryPluginPassword();
        String other$eventMeshRegistryPluginPassword = other.getEventMeshRegistryPluginPassword();
        if (this$eventMeshRegistryPluginPassword == null ? other$eventMeshRegistryPluginPassword != null : !this$eventMeshRegistryPluginPassword.equals(other$eventMeshRegistryPluginPassword)) {
            return false;
        }
        String this$eventMeshSecurityPublickey = this.getEventMeshSecurityPublickey();
        String other$eventMeshSecurityPublickey = other.getEventMeshSecurityPublickey();
        if (this$eventMeshSecurityPublickey == null ? other$eventMeshSecurityPublickey != null : !this$eventMeshSecurityPublickey.equals(other$eventMeshSecurityPublickey)) {
            return false;
        }
        List<String> this$eventMeshProvideServerProtocols = this.getEventMeshProvideServerProtocols();
        List<String> other$eventMeshProvideServerProtocols = other.getEventMeshProvideServerProtocols();
        if (this$eventMeshProvideServerProtocols == null ? other$eventMeshProvideServerProtocols != null : !((Object)this$eventMeshProvideServerProtocols).equals(other$eventMeshProvideServerProtocols)) {
            return false;
        }
        String this$eventMeshWebhookOrigin = this.getEventMeshWebhookOrigin();
        String other$eventMeshWebhookOrigin = other.getEventMeshWebhookOrigin();
        if (this$eventMeshWebhookOrigin == null ? other$eventMeshWebhookOrigin != null : !this$eventMeshWebhookOrigin.equals(other$eventMeshWebhookOrigin)) {
            return false;
        }
        String this$meshGroup = this.getMeshGroup();
        String other$meshGroup = other.getMeshGroup();
        return !(this$meshGroup == null ? other$meshGroup != null : !this$meshGroup.equals(other$meshGroup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEventMeshSecurityValidateTypeToken() ? 79 : 97);
        result = result * 59 + (this.isEventMeshServerTraceEnable() ? 79 : 97);
        result = result * 59 + (this.isEventMeshServerSecurityEnable() ? 79 : 97);
        result = result * 59 + (this.isEventMeshServerRegistryEnable() ? 79 : 97);
        Integer $eventMeshRegisterIntervalInMills = this.getEventMeshRegisterIntervalInMills();
        result = result * 59 + ($eventMeshRegisterIntervalInMills == null ? 43 : ((Object)$eventMeshRegisterIntervalInMills).hashCode());
        Integer $eventMeshFetchRegistryAddrInterval = this.getEventMeshFetchRegistryAddrInterval();
        result = result * 59 + ($eventMeshFetchRegistryAddrInterval == null ? 43 : ((Object)$eventMeshFetchRegistryAddrInterval).hashCode());
        String $sysID = this.getSysID();
        result = result * 59 + ($sysID == null ? 43 : $sysID.hashCode());
        String $eventMeshEnv = this.getEventMeshEnv();
        result = result * 59 + ($eventMeshEnv == null ? 43 : $eventMeshEnv.hashCode());
        String $eventMeshIDC = this.getEventMeshIDC();
        result = result * 59 + ($eventMeshIDC == null ? 43 : $eventMeshIDC.hashCode());
        String $eventMeshName = this.getEventMeshName();
        result = result * 59 + ($eventMeshName == null ? 43 : $eventMeshName.hashCode());
        String $eventMeshCluster = this.getEventMeshCluster();
        result = result * 59 + ($eventMeshCluster == null ? 43 : $eventMeshCluster.hashCode());
        String $eventMeshServerIp = this.getEventMeshServerIp();
        result = result * 59 + ($eventMeshServerIp == null ? 43 : $eventMeshServerIp.hashCode());
        String $namesrvAddr = this.getNamesrvAddr();
        result = result * 59 + ($namesrvAddr == null ? 43 : $namesrvAddr.hashCode());
        String $eventMeshTracePluginType = this.getEventMeshTracePluginType();
        result = result * 59 + ($eventMeshTracePluginType == null ? 43 : $eventMeshTracePluginType.hashCode());
        List<String> $eventMeshMetricsPluginType = this.getEventMeshMetricsPluginType();
        result = result * 59 + ($eventMeshMetricsPluginType == null ? 43 : ((Object)$eventMeshMetricsPluginType).hashCode());
        String $eventMeshRegistryPluginType = this.getEventMeshRegistryPluginType();
        result = result * 59 + ($eventMeshRegistryPluginType == null ? 43 : $eventMeshRegistryPluginType.hashCode());
        String $eventMeshSecurityPluginType = this.getEventMeshSecurityPluginType();
        result = result * 59 + ($eventMeshSecurityPluginType == null ? 43 : $eventMeshSecurityPluginType.hashCode());
        String $eventMeshConnectorPluginType = this.getEventMeshConnectorPluginType();
        result = result * 59 + ($eventMeshConnectorPluginType == null ? 43 : $eventMeshConnectorPluginType.hashCode());
        String $eventMeshStoragePluginType = this.getEventMeshStoragePluginType();
        result = result * 59 + ($eventMeshStoragePluginType == null ? 43 : $eventMeshStoragePluginType.hashCode());
        String $eventMeshRegistryPluginUsername = this.getEventMeshRegistryPluginUsername();
        result = result * 59 + ($eventMeshRegistryPluginUsername == null ? 43 : $eventMeshRegistryPluginUsername.hashCode());
        String $eventMeshRegistryPluginPassword = this.getEventMeshRegistryPluginPassword();
        result = result * 59 + ($eventMeshRegistryPluginPassword == null ? 43 : $eventMeshRegistryPluginPassword.hashCode());
        String $eventMeshSecurityPublickey = this.getEventMeshSecurityPublickey();
        result = result * 59 + ($eventMeshSecurityPublickey == null ? 43 : $eventMeshSecurityPublickey.hashCode());
        List<String> $eventMeshProvideServerProtocols = this.getEventMeshProvideServerProtocols();
        result = result * 59 + ($eventMeshProvideServerProtocols == null ? 43 : ((Object)$eventMeshProvideServerProtocols).hashCode());
        String $eventMeshWebhookOrigin = this.getEventMeshWebhookOrigin();
        result = result * 59 + ($eventMeshWebhookOrigin == null ? 43 : $eventMeshWebhookOrigin.hashCode());
        String $meshGroup = this.getMeshGroup();
        result = result * 59 + ($meshGroup == null ? 43 : $meshGroup.hashCode());
        return result;
    }

    public String toString() {
        return "CommonConfiguration(sysID=" + this.getSysID() + ", eventMeshEnv=" + this.getEventMeshEnv() + ", eventMeshIDC=" + this.getEventMeshIDC() + ", eventMeshName=" + this.getEventMeshName() + ", eventMeshCluster=" + this.getEventMeshCluster() + ", eventMeshServerIp=" + this.getEventMeshServerIp() + ", namesrvAddr=" + this.getNamesrvAddr() + ", eventMeshTracePluginType=" + this.getEventMeshTracePluginType() + ", eventMeshMetricsPluginType=" + this.getEventMeshMetricsPluginType() + ", eventMeshRegistryPluginType=" + this.getEventMeshRegistryPluginType() + ", eventMeshSecurityPluginType=" + this.getEventMeshSecurityPluginType() + ", eventMeshConnectorPluginType=" + this.getEventMeshConnectorPluginType() + ", eventMeshStoragePluginType=" + this.getEventMeshStoragePluginType() + ", eventMeshSecurityValidateTypeToken=" + this.isEventMeshSecurityValidateTypeToken() + ", eventMeshRegistryPluginUsername=" + this.getEventMeshRegistryPluginUsername() + ", eventMeshRegistryPluginPassword=" + this.getEventMeshRegistryPluginPassword() + ", eventMeshRegisterIntervalInMills=" + this.getEventMeshRegisterIntervalInMills() + ", eventMeshFetchRegistryAddrInterval=" + this.getEventMeshFetchRegistryAddrInterval() + ", eventMeshServerTraceEnable=" + this.isEventMeshServerTraceEnable() + ", eventMeshServerSecurityEnable=" + this.isEventMeshServerSecurityEnable() + ", eventMeshServerRegistryEnable=" + this.isEventMeshServerRegistryEnable() + ", eventMeshSecurityPublickey=" + this.getEventMeshSecurityPublickey() + ", eventMeshProvideServerProtocols=" + this.getEventMeshProvideServerProtocols() + ", eventMeshWebhookOrigin=" + this.getEventMeshWebhookOrigin() + ", meshGroup=" + this.getMeshGroup() + ")";
    }
}

