/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.GraphMatching;
import com.google.common.truth.Ordered;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class IterableSubject
extends Subject<IterableSubject, Iterable<?>> {
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    protected IterableSubject(FailureStrategy failureStrategy, @Nullable Iterable<?> list) {
        super(failureStrategy, list);
    }

    public final void isEmpty() {
        if (!Iterables.isEmpty((Iterable)((Iterable)this.actual()))) {
            this.fail("is empty");
        }
    }

    public final void isNotEmpty() {
        if (Iterables.isEmpty((Iterable)((Iterable)this.actual()))) {
            this.fail("is not empty");
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = Iterables.size((Iterable)((Iterable)this.actual()));
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public final void contains(@Nullable Object element) {
        if (!Iterables.contains((Iterable)((Iterable)this.actual()), (Object)element)) {
            this.failWithRawMessage("%s should have contained <%s>", this.actualAsString(), element);
        }
    }

    public final void doesNotContain(@Nullable Object element) {
        if (Iterables.contains((Iterable)((Iterable)this.actual()), (Object)element)) {
            this.failWithRawMessage("%s should not have contained <%s>", this.actualAsString(), element);
        }
    }

    public final void containsNoDuplicates() {
        ArrayList duplicates = Lists.newArrayList();
        for (Multiset.Entry entry : LinkedHashMultiset.create((Iterable)((Iterable)this.actual())).entrySet()) {
            if (entry.getCount() <= 1) continue;
            duplicates.add(entry);
        }
        if (!duplicates.isEmpty()) {
            this.failWithRawMessage("%s has the following duplicates: <%s>", this.actualAsString(), duplicates);
        }
    }

    public final void containsAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.containsAny("contains any of", SubjectUtils.accumulate(first, second, rest));
    }

    public final void containsAnyIn(Iterable<?> expected) {
        this.containsAny("contains any element in", expected);
    }

    private void containsAny(String failVerb, Iterable<?> expected) {
        Collection subject = this.actual() instanceof Collection ? (Collection)this.actual() : Lists.newArrayList((Iterable)((Iterable)this.actual()));
        for (Object item : expected) {
            if (!subject.contains(item)) continue;
            return;
        }
        this.fail(failVerb, (Object)expected);
    }

    @CanIgnoreReturnValue
    public final Ordered containsAllOf(@Nullable Object firstExpected, @Nullable Object secondExpected, Object ... restOfExpected) {
        return this.containsAll("contains all of", SubjectUtils.accumulate(firstExpected, secondExpected, restOfExpected));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAllIn(Iterable<?> expected) {
        return this.containsAll("contains all elements in", expected);
    }

    private Ordered containsAll(String failVerb, Iterable<?> expectedIterable) {
        LinkedList actual = Lists.newLinkedList((Iterable)((Iterable)this.actual()));
        ArrayList expected = Lists.newArrayList(expectedIterable);
        ArrayList missing = Lists.newArrayList();
        ArrayList actualNotInOrder = Lists.newArrayList();
        boolean ordered = true;
        for (Object e : expected) {
            int index = actual.indexOf(e);
            if (index != -1) {
                IterableSubject.moveElements(actual, actualNotInOrder, index);
                actual.remove(0);
                continue;
            }
            if (actualNotInOrder.remove(e)) {
                ordered = false;
                continue;
            }
            missing.add(e);
        }
        if (!missing.isEmpty()) {
            this.failWithBadResults(failVerb, expected, "is missing", SubjectUtils.countDuplicates(missing));
        }
        return ordered ? IN_ORDER : new NotInOrder("contains all elements in order", expected);
    }

    private static void moveElements(List<?> input, Collection<Object> output, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            output.add(input.remove(0));
        }
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(Object ... varargs) {
        ArrayList expected = varargs == null ? Lists.newArrayList((Object[])new Object[]{null}) : Arrays.asList(varargs);
        return this.containsExactly("contains exactly", expected, varargs != null && varargs.length == 1 && varargs[0] instanceof Iterable);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.containsExactly("contains exactly", expected, false);
    }

    private Ordered containsExactly(String failVerb, Iterable<?> required, boolean addElementsInWarning) {
        String failSuffix = addElementsInWarning ? ". Passing an iterable to the varargs method containsExactly(Object...) is often not the correct thing to do. Did you mean to call containsExactlyElementsIn(Iterable) instead?" : "";
        Iterator actualIter = ((Iterable)this.actual()).iterator();
        Iterator<?> requiredIter = required.iterator();
        while (actualIter.hasNext() && requiredIter.hasNext()) {
            Object requiredElement;
            Object actualElement = actualIter.next();
            if (Objects.equal(actualElement, requiredElement = requiredIter.next())) continue;
            ArrayList missing = Lists.newArrayList();
            missing.add(requiredElement);
            Iterators.addAll((Collection)missing, requiredIter);
            ArrayList extra = Lists.newArrayList();
            if (!missing.remove(actualElement)) {
                extra.add(actualElement);
            }
            while (actualIter.hasNext()) {
                Object item = actualIter.next();
                if (missing.remove(item)) continue;
                extra.add(item);
            }
            if (!missing.isEmpty()) {
                if (!extra.isEmpty()) {
                    this.failWithRawMessage("Not true that %s %s <%s>. It is missing <%s> and has unexpected items <%s>%s", this.actualAsString(), failVerb, required, SubjectUtils.countDuplicates(missing), SubjectUtils.countDuplicates(extra), failSuffix);
                } else {
                    this.failWithBadResultsAndSuffix(failVerb, required, "is missing", SubjectUtils.countDuplicates(missing), failSuffix);
                }
            }
            if (!extra.isEmpty()) {
                this.failWithBadResultsAndSuffix(failVerb, required, "has unexpected items", SubjectUtils.countDuplicates(extra), failSuffix);
            }
            return new NotInOrder("contains only these elements in order", required);
        }
        if (actualIter.hasNext()) {
            this.failWithBadResultsAndSuffix(failVerb, required, "has unexpected items", SubjectUtils.countDuplicates(Lists.newArrayList(actualIter)), failSuffix);
        } else if (requiredIter.hasNext()) {
            this.failWithBadResultsAndSuffix(failVerb, required, "is missing", SubjectUtils.countDuplicates(Lists.newArrayList(requiredIter)), failSuffix);
        }
        return IN_ORDER;
    }

    protected final void failWithBadResultsAndSuffix(String verb, Object expected, String failVerb, Object actual, String suffix) {
        this.failWithRawMessage("Not true that %s %s <%s>. It %s <%s>%s", this.actualAsString(), verb, expected, failVerb, actual == null ? "null reference" : actual, suffix);
    }

    public final void containsNoneOf(@Nullable Object firstExcluded, @Nullable Object secondExcluded, Object ... restOfExcluded) {
        this.containsNone("contains none of", SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
    }

    public final void containsNoneIn(Iterable<?> excluded) {
        this.containsNone("contains no elements in", excluded);
    }

    private void containsNone(String failVerb, Iterable<?> excluded) {
        ArrayList present = new ArrayList();
        for (Object item : Sets.newLinkedHashSet(excluded)) {
            if (!Iterables.contains((Iterable)((Iterable)this.actual()), item)) continue;
            present.add(item);
        }
        if (!present.isEmpty()) {
            this.failWithBadResults(failVerb, excluded, "contains", present);
        }
    }

    public final void isStrictlyOrdered() {
        this.isStrictlyOrdered((Comparator<?>)Ordering.natural());
    }

    public final void isStrictlyOrdered(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck(new PairwiseChecker(){

            @Override
            public void check(Object prev, Object next) {
                if (comparator.compare(prev, next) >= 0) {
                    IterableSubject.this.fail("is strictly ordered", prev, next);
                }
            }
        });
    }

    public final void isOrdered() {
        this.isOrdered((Comparator<?>)Ordering.natural());
    }

    @Deprecated
    public final void isPartiallyOrdered() {
        this.isOrdered();
    }

    public final void isOrdered(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck(new PairwiseChecker(){

            @Override
            public void check(Object prev, Object next) {
                if (comparator.compare(prev, next) > 0) {
                    IterableSubject.this.fail("is ordered", prev, next);
                }
            }
        });
    }

    @Deprecated
    public final void isPartiallyOrdered(Comparator<?> comparator) {
        this.isOrdered(comparator);
    }

    private void pairwiseCheck(PairwiseChecker checker) {
        Iterator iterator = ((Iterable)this.actual()).iterator();
        if (iterator.hasNext()) {
            Object prev = iterator.next();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                checker.check(prev, next);
                prev = next;
            }
        }
    }

    public <A, E> UsingCorrespondence<A, E> comparingElementsUsing(Correspondence<A, E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<A, E> correspondence;

        private UsingCorrespondence(Correspondence<A, E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void contains(@Nullable E expected) {
            for (A actual : this.getCastSubject()) {
                if (!this.correspondence.compare(actual, expected)) continue;
                return;
            }
            IterableSubject.this.fail("contains at least one element that " + this.correspondence, (Object)expected);
        }

        public void doesNotContain(@Nullable E excluded) {
            ArrayList<A> matchingElements = new ArrayList<A>();
            for (A actual : this.getCastSubject()) {
                if (!this.correspondence.compare(actual, excluded)) continue;
                matchingElements.add(actual);
            }
            if (!matchingElements.isEmpty()) {
                IterableSubject.this.failWithRawMessage("%s should not have contained an element that %s <%s>. It contained the following such elements: <%s>", IterableSubject.this.actualAsString(), this.correspondence, excluded, matchingElements);
            }
        }

        @CanIgnoreReturnValue
        private Ordered containsExactly(E ... expected) {
            throw new UnsupportedOperationException();
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(Iterable<? extends E> expected) {
            if (this.correspondInOrder(this.getCastSubject().iterator(), expected.iterator())) {
                return IN_ORDER;
            }
            ImmutableList actualList = ImmutableList.copyOf(this.getCastSubject());
            ImmutableList expectedList = ImmutableList.copyOf(expected);
            ImmutableSetMultimap<Integer, Integer> candidateMapping = this.findCandidateMapping((List<? extends A>)actualList, (List<? extends E>)expectedList);
            this.failIfCandidateMappingHasMissingOrExtra((List<? extends A>)actualList, (List<? extends E>)expectedList, (ImmutableMultimap<Integer, Integer>)candidateMapping);
            ImmutableBiMap<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping((ImmutableMultimap<Integer, Integer>)candidateMapping);
            this.failIfOneToOneMappingHasMissingOrExtra((List<? extends A>)actualList, (List<? extends E>)expectedList, (BiMap<Integer, Integer>)maximalOneToOneMapping);
            return new NotInOrder("contains, in order, exactly one element that " + this.correspondence + " each element of", expected);
        }

        private boolean correspondInOrder(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            while (actual.hasNext() && expected.hasNext()) {
                E expectedElement;
                A actualElement = actual.next();
                if (this.correspondence.compare(actualElement, expectedElement = expected.next())) continue;
                return false;
            }
            return !actual.hasNext() && !expected.hasNext();
        }

        private ImmutableSetMultimap<Integer, Integer> findCandidateMapping(List<? extends A> actual, List<? extends E> expected) {
            ImmutableSetMultimap.Builder mapping = ImmutableSetMultimap.builder();
            for (int actualIndex = 0; actualIndex < actual.size(); ++actualIndex) {
                for (int expectedIndex = 0; expectedIndex < expected.size(); ++expectedIndex) {
                    if (!this.correspondence.compare(actual.get(actualIndex), expected.get(expectedIndex))) continue;
                    mapping.put((Object)actualIndex, (Object)expectedIndex);
                }
            }
            return mapping.build();
        }

        void failIfCandidateMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, ImmutableMultimap<Integer, Integer> mapping) {
            ImmutableList<? extends E> missing;
            ImmutableList<? extends A> extra = this.findNotIndexed(actual, (Set<Integer>)mapping.keySet());
            Optional<String> missingOrExtraMessage = this.describeMissingOrExtra((List<? extends A>)extra, (List<? extends E>)(missing = this.findNotIndexed(expected, (Set<Integer>)mapping.inverse().keySet())));
            if (missingOrExtraMessage.isPresent()) {
                IterableSubject.this.failWithRawMessage("Not true that %s contains exactly one element that %s each element of <%s>. It %s", IterableSubject.this.actualAsString(), this.correspondence, expected, missingOrExtraMessage.get());
            }
        }

        private Optional<String> describeMissingOrExtra(List<? extends A> extra, List<? extends E> missing) {
            if (!missing.isEmpty() && !extra.isEmpty()) {
                return Optional.of((Object)StringUtil.format("is missing an element that %s %s and has unexpected elements <%s>", this.correspondence, this.formatMissing(missing), extra));
            }
            if (!missing.isEmpty()) {
                return Optional.of((Object)StringUtil.format("is missing an element that %s %s", this.correspondence, this.formatMissing(missing)));
            }
            if (!extra.isEmpty()) {
                return Optional.of((Object)StringUtil.format("has unexpected elements <%s>", extra));
            }
            return Optional.absent();
        }

        private <T> ImmutableList<T> findNotIndexed(List<T> list, Set<Integer> indexes) {
            if (indexes.size() == list.size()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder notIndexed = ImmutableList.builder();
            for (int index = 0; index < list.size(); ++index) {
                if (indexes.contains(index)) continue;
                notIndexed.add(list.get(index));
            }
            return notIndexed.build();
        }

        private String formatMissing(List<?> missing) {
            if (missing.size() == 1) {
                return "<" + missing.get(0) + ">";
            }
            return "each of <" + missing + ">";
        }

        private ImmutableBiMap<Integer, Integer> findMaximalOneToOneMapping(ImmutableMultimap<Integer, Integer> edges) {
            return GraphMatching.maximumCardinalityBipartiteMatching(edges);
        }

        void failIfOneToOneMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, BiMap<Integer, Integer> mapping) {
            ImmutableList<? extends E> missing;
            ImmutableList<? extends A> extra = this.findNotIndexed(actual, mapping.keySet());
            Optional<String> missingOrExtraMessage = this.describeMissingOrExtra((List<? extends A>)extra, (List<? extends E>)(missing = this.findNotIndexed(expected, mapping.inverse().keySet())));
            if (missingOrExtraMessage.isPresent()) {
                IterableSubject.this.failWithRawMessage("Not true that %s contains exactly one element that %s each element of <%s>. It contains at least one element that matches each expected element, and every element it contains matches at least one expected element, but there was no 1:1 mapping between all the actual and expected elements. Using the most complete 1:1 mapping (or one such mapping, if there is a tie), it %s", IterableSubject.this.actualAsString(), this.correspondence, expected, missingOrExtraMessage.get());
            }
        }

        @CanIgnoreReturnValue
        private Ordered containsAllOf(@Nullable E first, @Nullable E second, E ... rest) {
            throw new UnsupportedOperationException();
        }

        @CanIgnoreReturnValue
        private Ordered containsAllIn(Iterable<E> unused) {
            throw new UnsupportedOperationException();
        }

        private void containsAnyOf(@Nullable E first, @Nullable E second, E ... rest) {
            throw new UnsupportedOperationException();
        }

        private void containsAnyIn(Iterable<E> unused) {
            throw new UnsupportedOperationException();
        }

        private void containsNoneOf(@Nullable E first, @Nullable E second, E ... rest) {
            throw new UnsupportedOperationException();
        }

        private void containsNoneIn(Iterable<E> unused) {
            throw new UnsupportedOperationException();
        }

        private Iterable<A> getCastSubject() {
            return (Iterable)IterableSubject.this.actual();
        }
    }

    private static interface PairwiseChecker {
        public void check(Object var1, Object var2);
    }

    private class NotInOrder
    implements Ordered {
        private final String check;
        private final Iterable<?> required;

        NotInOrder(String check, Iterable<?> required) {
            this.check = check;
            this.required = required;
        }

        @Override
        public void inOrder() {
            IterableSubject.this.fail(this.check, (Object)this.required);
        }
    }
}

