/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.trace;

import com.navercorp.pinpoint.common.trace.AnnotationKeyMatcher;
import com.navercorp.pinpoint.common.trace.AnnotationKeyMatcherLocator;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.common.util.apache.IntHashMapUtils;
import java.util.HashMap;
import java.util.Objects;

public class AnnotationKeyMatcherRegistry
implements AnnotationKeyMatcherLocator {
    private final IntHashMap<AnnotationKeyMatcher> annotationMatcherMap;

    private AnnotationKeyMatcherRegistry(IntHashMap<AnnotationKeyMatcher> annotationMatcherMap) {
        this.annotationMatcherMap = Objects.requireNonNull(annotationMatcherMap, "annotationMatcherMap");
    }

    public AnnotationKeyMatcher findAnnotationKeyMatcher(short serviceType) {
        return (AnnotationKeyMatcher)this.annotationMatcherMap.get((int)serviceType);
    }

    static class Builder {
        private final HashMap<Integer, AnnotationKeyMatcher> buildMap = new HashMap();

        Builder() {
        }

        AnnotationKeyMatcher addAnnotationKeyMatcher(ServiceType serviceType, AnnotationKeyMatcher annotationKeyMatcher) {
            Objects.requireNonNull(serviceType, "serviceType");
            Objects.requireNonNull(annotationKeyMatcher, "annotationKeyMatcher");
            short code = serviceType.getCode();
            return this.buildMap.put(Integer.valueOf(code), annotationKeyMatcher);
        }

        AnnotationKeyMatcherRegistry build() {
            IntHashMap copy = IntHashMapUtils.copy(this.buildMap);
            return new AnnotationKeyMatcherRegistry(copy);
        }
    }
}

