/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.maven.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import org.apache.felix.atomos.maven.LauncherBuilderUtil;
import org.apache.felix.atomos.maven.configs.MavenClassPathConfig;
import org.apache.felix.atomos.maven.configs.MavenClasspathMavenConfig;
import org.apache.felix.atomos.maven.configs.MavenIndexConfig;
import org.apache.felix.atomos.utils.api.Launcher;
import org.apache.felix.atomos.utils.api.LauncherBuilder;
import org.apache.felix.atomos.utils.core.plugins.collector.PathCollectorPlugin;
import org.apache.felix.atomos.utils.core.plugins.collector.PathCollectorPluginConfig;
import org.apache.felix.atomos.utils.core.plugins.index.IndexOutputType;
import org.apache.felix.atomos.utils.core.plugins.index.IndexPlugin;
import org.apache.felix.atomos.utils.core.plugins.index.IndexPluginConfig;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="atomos-index", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AtomosIndexMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=false)
    private MavenProject project;
    @Parameter(required=false, readonly=false)
    private MavenIndexConfig index;
    @Parameter(required=false, readonly=false)
    private MavenClassPathConfig classpath;

    public static boolean isJarFile(Artifact a) {
        boolean bl;
        JarFile j = new JarFile(a.getFile());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    j.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        j.close();
        return bl;
    }

    public void execute() throws MojoExecutionException {
        if (this.index == null) {
            this.index = new MavenIndexConfig();
        }
        if (this.classpath == null) {
            MavenClassPathConfig classPathConfig = new MavenClassPathConfig();
            MavenClasspathMavenConfig mavenIndexMojoConfig = new MavenClasspathMavenConfig();
            classPathConfig.maven = List.of(mavenIndexMojoConfig);
            this.classpath = classPathConfig;
        }
        if (this.index.indexOutputType == null) {
            this.index.indexOutputType = IndexOutputType.DIRECTORY;
        }
        try {
            File outputDirectory = this.project.getBasedir();
            Files.createDirectories(outputDirectory.toPath(), new FileAttribute[0]);
            LauncherBuilder builder = Launcher.builder();
            Optional.ofNullable(this.classpath.paths).orElse(List.of()).forEach(cc -> {
                PathCollectorPluginConfig pc = LauncherBuilderUtil.processClasspathFile(cc);
                builder.addPlugin(PathCollectorPlugin.class, (Object)pc);
            });
            Optional.ofNullable(this.classpath.maven).orElse(List.of()).forEach(cc -> {
                PathCollectorPluginConfig pc = LauncherBuilderUtil.processClasspathMaven(this.project, cc);
                builder.addPlugin(PathCollectorPlugin.class, (Object)pc);
            });
            IndexPluginConfig ic = LauncherBuilderUtil.processIndex(this.index, this.project);
            builder.addPlugin(IndexPlugin.class, (Object)ic);
            builder.build().execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }
}

