/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.client.feign.services;

import feign.Param;
import feign.RequestLine;
import feign.Response;
import java.util.List;
import org.apache.fineract.client.models.DeleteEntityTypeEntityIdDocumentsResponse;
import org.apache.fineract.client.models.DocumentData;
import org.apache.fineract.client.models.PostEntityTypeEntityIdDocumentsResponse;
import org.apache.fineract.client.models.PutEntityTypeEntityIdDocumentsResponse;

/**
 * This class was originally generated by OpenAPI Generator (https://openapi-generator.tech), but then had to be
 * manually edited to manually fix https://issues.apache.org/jira/browse/FINERACT-1227. If we could fix our OpenAPI /
 * Swagger YAML generation from the JAX RS and OpenAPI annotation to have the correct notation for binary document files
 * and images, then this could be removed again.
 */
public interface DocumentsApiFixed {

    /**
     * Create a Document Note: A document is created using a Multi-part form upload Body Parts name : Name or summary of
     * the document description : Description of the document file : The file to be uploaded Mandatory Fields : file and
     * description
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param file
     *            (required)
     * @param name
     *            name (optional)
     * @param description
     *            description (optional)
     * @return PostEntityTypeEntityIdDocumentsResponse
     */
    @RequestLine("POST /v1/{entityType}/{entityId}/documents")
    PostEntityTypeEntityIdDocumentsResponse createDocument(@Param("entityType") String entityType, @Param("entityId") Long entityId,
            org.apache.fineract.client.feign.FineractMultipartEncoder.MultipartData multipartData);

    /**
     * Remove a Document
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @return DeleteEntityTypeEntityIdDocumentsResponse
     */
    @RequestLine("DELETE /v1/{entityType}/{entityId}/documents/{documentId}")
    DeleteEntityTypeEntityIdDocumentsResponse deleteDocument(@Param("entityType") String entityType, @Param("entityId") Long entityId,
            @Param("documentId") Long documentId);

    /**
     * Retrieve Binary File associated with Document Request used to download the file associated with the document
     * Example Requests: clients/1/documents/1/attachment loans/1/documents/1/attachment
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @return Response
     */
    @RequestLine("GET /v1/{entityType}/{entityId}/documents/{documentId}/attachment")
    @feign.Headers("Accept: */*")
    Response downloadFile(@Param("entityType") String entityType, @Param("entityId") Long entityId, @Param("documentId") Long documentId);

    /**
     * Retrieve a Document Example Requests: clients/1/documents/1 loans/1/documents/1
     * client_identifiers/1/documents/1?fields=name,description
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @return DocumentData
     */
    @RequestLine("GET /v1/{entityType}/{entityId}/documents/{documentId}")
    DocumentData getDocument(@Param("entityType") String entityType, @Param("entityId") Long entityId,
            @Param("documentId") Long documentId);

    /**
     * List documents Example Requests: clients/1/documents client_identifiers/1/documents
     * loans/1/documents?fields=name,description
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @return List&lt;DocumentData&gt;
     */
    @RequestLine("GET /v1/{entityType}/{entityId}/documents")
    List<DocumentData> retrieveAllDocuments(@Param("entityType") String entityType, @Param("entityId") Long entityId);

    /**
     * Update a Document Note: A document is updated using a Multi-part form upload Body Parts name Name or summary of
     * the document description Description of the document file The file to be uploaded
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @param file
     *            (optional)
     * @param name
     *            name (optional)
     * @param description
     *            description (optional)
     * @return PutEntityTypeEntityIdDocumentsResponse
     */
    @RequestLine("PUT /v1/{entityType}/{entityId}/documents/{documentId}")
    PutEntityTypeEntityIdDocumentsResponse updateDocument(@Param("entityType") String entityType, @Param("entityId") Long entityId,
            @Param("documentId") Long documentId, org.apache.fineract.client.feign.FineractMultipartEncoder.MultipartData multipartData);
}
