/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.prompt;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.agents.api.chat.messages.ChatMessage;
import org.apache.flink.agents.api.chat.messages.MessageRole;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.resource.SerializableResource;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;

public class Prompt
extends SerializableResource {
    private static final String FIELD_TEMPLATE = "template";
    @JsonProperty(value="template")
    private final PromptTemplate template;
    private static final Pattern BRACE_PATTERN = Pattern.compile("\\{([^}]+)\\}");

    @JsonCreator
    private Prompt(@JsonProperty(value="template") PromptTemplate promptTemplate) {
        this.template = promptTemplate;
    }

    public Prompt(String template) {
        this.template = PromptTemplate.fromString(template);
    }

    public Prompt(List<ChatMessage> template) {
        this.template = PromptTemplate.fromMessages(template);
    }

    public String formatString(Map<String, String> kwargs) {
        return this.template.match(content -> Prompt.format(content, kwargs), messages -> {
            ArrayList<CallSite> formattedMessages = new ArrayList<CallSite>();
            for (ChatMessage message : messages) {
                String formattedContent = Prompt.format(message.getContent(), kwargs);
                String formatted = message.getRole().getValue() + ": " + formattedContent;
                formattedMessages.add((CallSite)((Object)formatted));
            }
            return String.join((CharSequence)"\n", formattedMessages);
        });
    }

    public List<ChatMessage> formatMessages(MessageRole defaultRole, Map<String, String> kwargs) {
        return this.template.match(content -> Collections.singletonList(new ChatMessage(defaultRole, Prompt.format(content, kwargs))), messages -> messages.stream().map(message -> new ChatMessage(message.getRole(), Prompt.format(message.getContent(), kwargs))).collect(Collectors.toList()));
    }

    @Override
    @JsonIgnore
    public ResourceType getResourceType() {
        return ResourceType.PROMPT;
    }

    private static String format(String template, Map<String, String> kwargs) {
        if (template == null) {
            return "";
        }
        String result = template;
        for (Map.Entry<String, String> entry : kwargs.entrySet()) {
            String placeholder = "{" + entry.getKey() + "}";
            String value = entry.getValue() != null ? entry.getValue() : "";
            result = result.replace(placeholder, value);
        }
        return result;
    }

    private static class MessagesTemplate
    extends PromptTemplate {
        private static final String FIELD_MESSAGES = "messages";
        @JsonProperty(value="messages")
        private final List<ChatMessage> messages;

        @JsonCreator
        public MessagesTemplate(@JsonProperty(value="messages") List<ChatMessage> messages) {
            Objects.requireNonNull(messages, "messages cannot be null");
            if (messages.isEmpty()) {
                throw new IllegalArgumentException("Messages cannot be empty");
            }
            this.messages = new ArrayList<ChatMessage>(messages);
        }

        public List<ChatMessage> getMessages() {
            return new ArrayList<ChatMessage>(this.messages);
        }

        @Override
        public <T> T match(Function<String, T> onString, Function<List<ChatMessage>, T> onMessages) {
            return onMessages.apply(new ArrayList<ChatMessage>(this.messages));
        }

        public String toString() {
            return "MessagesTemplate{messages=" + this.messages.size() + " items}";
        }
    }

    private static class StringTemplate
    extends PromptTemplate {
        private static final String FIELD_CONTENT = "content";
        @JsonProperty(value="content")
        private final String content;

        @JsonCreator
        public StringTemplate(@JsonProperty(value="content") String content) {
            this.content = Objects.requireNonNull(content, "content cannot be null");
        }

        public String getContent() {
            return this.content;
        }

        @Override
        public <T> T match(Function<String, T> onString, Function<List<ChatMessage>, T> onMessages) {
            return onString.apply(this.content);
        }

        public String toString() {
            return "StringTemplate{content='" + this.content + "'}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    private static abstract class PromptTemplate {
        private PromptTemplate() {
        }

        public static PromptTemplate fromString(String content) {
            return new StringTemplate(content);
        }

        public static PromptTemplate fromMessages(List<ChatMessage> messages) {
            return new MessagesTemplate(messages);
        }

        public abstract <T> T match(Function<String, T> var1, Function<List<ChatMessage>, T> var2);
    }
}

