/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.fory.format.encoder;

import java.util.Collection;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fory.format.row.binary.BinaryArray;
import org.apache.fory.format.row.binary.BinaryMap;
import org.apache.fory.format.row.binary.BinaryRow;
import org.apache.fory.format.row.binary.writer.BaseBinaryRowWriter;
import org.apache.fory.format.row.binary.writer.BinaryArrayWriter;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.TypeRef;

interface Encoding {
  BaseBinaryRowWriter newWriter(Schema schema);

  BaseBinaryRowWriter newWriter(Schema schema, MemoryBuffer buffer);

  BinaryArrayWriter newArrayWriter(Field field);

  BinaryArrayWriter newArrayWriter(Field field, MemoryBuffer buffer);

  RowEncoderBuilder newRowEncoder(TypeRef<?> beanType);

  ArrayEncoderBuilder newArrayEncoder(
      TypeRef<? extends Collection<?>> collectionType, TypeRef<?> elementType);

  MapEncoderBuilder newMapEncoder(TypeRef<? extends Map<?, ?>> mapType, TypeRef<?> beanToken);

  BinaryRow newRow(Schema schema);

  BinaryArray newArray(Field field);

  BinaryMap newMap(Field field);
}
