/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.Properties;
import org.apache.gravitino.cli.commands.Command;

public class FilesetCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private final String catalog;
    private final String schema;
    private String fileset;

    public FilesetCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
        this.catalog = this.name.getCatalogName();
        this.schema = this.name.getSchemaName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        ArrayList<String> missingEntities = Lists.newArrayList();
        if (this.catalog == null) {
            missingEntities.add("catalog");
        }
        if (this.schema == null) {
            missingEntities.add("schema");
        }
        if ("list".equals(this.command)) {
            this.checkEntities(missingEntities);
            this.handleListCommand();
            return;
        }
        this.fileset = this.name.getFilesetName();
        if (this.fileset == null) {
            missingEntities.add("fileset");
        }
        this.checkEntities(missingEntities);
        if (!this.executeCommand()) {
            System.err.println("Entity doesn't support this action.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
            case "properties": {
                this.handlePropertiesCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        this.gravitinoCommandLine.newFilesetDetails(this.context, this.metalake, this.catalog, this.schema, this.fileset).validate().handle();
    }

    private void handleCreateCommand() {
        String comment = this.line.getOptionValue("comment");
        String[] properties = this.line.getOptionValues("properties");
        Map<String, String> propertyMap = new Properties().parse(properties);
        this.gravitinoCommandLine.newCreateFileset(this.context, this.metalake, this.catalog, this.schema, this.fileset, comment, propertyMap).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteFileset(this.context, this.metalake, this.catalog, this.schema, this.fileset).validate().handle();
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        this.gravitinoCommandLine.newSetFilesetProperty(this.context, this.metalake, this.catalog, this.schema, this.fileset, property, value).validate().handle();
    }

    private void handleRemoveCommand() {
        String property = this.line.getOptionValue("property");
        this.gravitinoCommandLine.newRemoveFilesetProperty(this.context, this.metalake, this.catalog, this.schema, this.fileset, property).validate().handle();
    }

    private void handlePropertiesCommand() {
        this.gravitinoCommandLine.newListFilesetProperties(this.context, this.metalake, this.catalog, this.schema, this.fileset).validate().handle();
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListFilesets(this.context, this.metalake, this.catalog, this.schema).validate().handle();
    }

    private void handleUpdateCommand() {
        if (!this.line.hasOption("comment") && !this.line.hasOption("rename")) {
            System.err.println("Missing --comment and --rename options.");
            Main.exit(-1);
        }
        if (this.line.hasOption("comment")) {
            String comment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateFilesetComment(this.context, this.metalake, this.catalog, this.schema, this.fileset, comment).validate().handle();
        }
        if (this.line.hasOption("rename")) {
            String newName = this.line.getOptionValue("rename");
            this.gravitinoCommandLine.newUpdateFilesetName(this.context, this.metalake, this.catalog, this.schema, this.fileset, newName).validate().handle();
        }
    }
}

