/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Arrays;
import java.util.List;
import org.apache.gravitino.Audit;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListUsers
extends Command {
    protected final String metalake;

    public ListUsers(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        String[] users = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            users = client.listUserNames();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (users.length == 0) {
            this.printInformation("No users exist.");
        } else {
            User[] userObjects = (User[])Arrays.stream(users).map(this::getUser).toArray(User[]::new);
            this.printResults(userObjects);
        }
    }

    private User getUser(final String user) {
        return new User(){

            @Override
            public String name() {
                return user;
            }

            @Override
            public List<String> roles() {
                return null;
            }

            @Override
            public Audit auditInfo() {
                return null;
            }
        };
    }
}

